/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.opera.core.systems.internal.ImplicitWait;
import com.opera.core.systems.internal.OperaDefaults;
import com.opera.core.systems.internal.VersionUtil;
import com.opera.core.systems.runner.OperaRunner;
import com.opera.core.systems.scope.Message;
import com.opera.core.systems.scope.ScopeService;
import com.opera.core.systems.scope.Service;
import com.opera.core.systems.scope.WaitState;
import com.opera.core.systems.scope.exceptions.CommunicationException;
import com.opera.core.systems.scope.exceptions.ScopeException;
import com.opera.core.systems.scope.handlers.ConnectionHandler;
import com.opera.core.systems.scope.handlers.ScopeEventHandler;
import com.opera.core.systems.scope.internal.OperaIntervals;
import com.opera.core.systems.scope.protos.DesktopWmProtos;
import com.opera.core.systems.scope.protos.ScopeProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.ConsoleLogger;
import com.opera.core.systems.scope.services.CookieManager;
import com.opera.core.systems.scope.services.Core;
import com.opera.core.systems.scope.services.Debugger;
import com.opera.core.systems.scope.services.EcmascriptDebugger;
import com.opera.core.systems.scope.services.Exec;
import com.opera.core.systems.scope.services.Prefs;
import com.opera.core.systems.scope.services.Selftest;
import com.opera.core.systems.scope.services.WindowManager;
import com.opera.core.systems.scope.services.desktop.DesktopUtils;
import com.opera.core.systems.scope.services.desktop.DesktopWindowManager;
import com.opera.core.systems.scope.stp.StpConnection;
import com.opera.core.systems.scope.stp.StpThread;
import com.opera.core.systems.scope.stp.services.MockEcmascriptDebugger;
import com.opera.core.systems.scope.stp.services.desktop.ScopeSystemInputManager;
import com.opera.core.systems.scope.stp.services.messages.ScopeMessage;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class ScopeServices
implements ConnectionHandler {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final SortedSet<ScopeService> requiredServices = Sets.newTreeSet();
    private final StpThread stpThread;
    private final AtomicInteger tagCounter;
    private final WaitState waitState = new WaitState();
    private Core core;
    private Debugger debugger;
    private Exec exec;
    private WindowManager windowManager;
    private ConsoleLogger consoleLogger;
    private DesktopWindowManager desktopWindowManager;
    private DesktopUtils desktopUtils;
    private Prefs prefs;
    private ScopeSystemInputManager systemInputManager;
    private CookieManager cookieManager;
    private Selftest selftest;
    private StpConnection connection = null;
    private boolean shutdown = false;
    private Map<ScopeService, Service> services = ImmutableMap.of();
    private Map<ScopeService, String> availableServices = ImmutableMap.of();

    public ScopeServices(SortedSet<ScopeService> requiredServices, int port, boolean manualConnect) throws IOException {
        this.requiredServices.addAll(requiredServices);
        this.tagCounter = new AtomicInteger();
        this.stpThread = new StpThread(port, this, new ScopeEventHandler(this), manualConnect);
    }

    public void init() {
        this.waitForHandshake();
        this.availableServices = this.buildAvailableServices(this.getHostInfo());
        this.connect();
        if (OperaDefaults.ENABLE_DEBUGGER && !this.requiredServices.contains((Object)ScopeService.ECMASCRIPT) && !this.requiredServices.contains((Object)ScopeService.ECMASCRIPT_DEBUGGER)) {
            if (this.availableServices.containsKey((Object)ScopeService.ECMASCRIPT)) {
                this.requiredServices.add(ScopeService.ECMASCRIPT);
            } else {
                this.requiredServices.add(ScopeService.ECMASCRIPT_DEBUGGER);
            }
        } else {
            this.debugger = new MockEcmascriptDebugger();
        }
        this.services = this.createServices(this.requiredServices);
        this.enableServices(this.services.values());
        this.initializeServices(this.services.values());
    }

    private Map<ScopeService, String> buildAvailableServices(ScopeProtos.HostInfo info) {
        ImmutableMap.Builder<ScopeService, String> services = ImmutableMap.builder();
        for (ScopeProtos.Service service : info.getServiceListList()) {
            ScopeService scopeService = ScopeService.get(service.getName());
            if (scopeService == null) continue;
            services.put(scopeService, service.getVersion());
        }
        return services.build();
    }

    private Map<ScopeService, Service> createServices(Set<ScopeService> services) {
        TreeMap<ScopeService, Service> actualServices = Maps.newTreeMap();
        for (ScopeService requiredService : services) {
            if (!this.availableServices.containsKey((Object)requiredService)) continue;
            for (ScopeService availableService : this.availableServices.keySet()) {
                if (availableService != requiredService) continue;
                actualServices.put(requiredService, requiredService.newInstance(this));
            }
        }
        return actualServices;
    }

    private void initializeServices(Collection<Service> services) {
        for (Service service : services) {
            this.logger.finer(String.format("Initializing service %s (version %s)", service.getServiceName(), service.getServiceVersion()));
            service.init();
        }
    }

    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    public void shutdown() {
        this.shutdown = true;
        if (this.isConnected()) {
            this.connection.close();
        }
        this.stpThread.shutdown();
        try {
            this.stpThread.join();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private void waitForHandshake() throws ScopeException {
        try {
            this.waitState.waitForHandshake(OperaIntervals.HANDSHAKE_TIMEOUT.getMs());
        }
        catch (ScopeException e) {
            this.shutdown();
            throw e;
        }
    }

    private ScopeProtos.HostInfo getHostInfo() {
        UmsProtos.Response response = this.executeMessage(ScopeMessage.HOST_INFO, null);
        try {
            return ScopeProtos.HostInfo.parseFrom(response.getPayload());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CommunicationException("Error while parsing host info", e);
        }
    }

    private void connect() {
        ScopeProtos.ClientInfo.Builder info = ScopeProtos.ClientInfo.newBuilder().setFormat("protobuf");
        this.executeMessage(ScopeMessage.CONNECT, info);
    }

    public void enableServices(Collection<Service> services) {
        for (Service service : services) {
            try {
                this.enable(service);
            }
            catch (InvalidProtocolBufferException e) {
                throw new ScopeException("Could not parse the message", e);
            }
        }
    }

    private ScopeProtos.ServiceResult enable(Service service) throws InvalidProtocolBufferException {
        ScopeProtos.ServiceSelection.Builder selection = ScopeProtos.ServiceSelection.newBuilder();
        selection.setName(service.getServiceName());
        UmsProtos.Response response = this.executeMessage(ScopeMessage.ENABLE, selection);
        return ScopeProtos.ServiceResult.parseFrom(response.getPayload());
    }

    public void quitOpera(final OperaRunner runner) throws IOException {
        if (!this.isConnected()) {
            return;
        }
        if (this.exec != null) {
            try {
                if (this.exec.getActionList().contains("Quit")) {
                    this.exec.action("Quit", new String[0]);
                } else if (this.exec.getActionList().contains("Exit")) {
                    this.exec.action("Exit", new String[0]);
                }
            }
            catch (CommunicationException e) {
                throw new IOException("Exception on shutdown: " + e.getMessage(), e);
            }
        }
        if (runner != null) {
            new ImplicitWait(OperaIntervals.QUIT_RESPONSE_TIMEOUT.getValue()).until(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return runner.isOperaRunning();
                }
            });
            if (runner.isOperaRunning()) {
                throw new IOException("Opera is still running!");
            }
        }
    }

    public Map<ScopeService, String> getAvailableServices() {
        return this.availableServices;
    }

    public void quit() throws IOException {
        this.quit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit(OperaRunner runner) throws IOException {
        try {
            this.quitOpera(runner);
        }
        finally {
            this.shutdown();
        }
    }

    @Override
    public boolean onConnected(StpConnection con) {
        this.logger.finest("onConnect fired");
        if (this.connection == null) {
            this.logger.finest("Got StpConnection");
            this.connection = con;
            return true;
        }
        this.logger.warning("StpConnection already attached - closing incoming connection.");
        return false;
    }

    @Override
    public void onServiceList(List<String> services) {
    }

    public void onWindowLoaded(int id) {
        this.logger.finest("Window loaded: windowId=" + id);
        this.waitState.onWindowLoaded(id);
    }

    public void onWindowClosed(int id) {
        this.logger.finest("Window closed: windowId=" + id);
        this.waitState.onWindowClosed(id);
    }

    public void onDesktopWindowShown(DesktopWmProtos.DesktopWindowInfo info) {
        this.logger.finest("DesktopWindow shown: windowId=" + info.getWindowID());
        this.waitState.onDesktopWindowShown(info);
    }

    public void onDesktopWindowUpdated(DesktopWmProtos.DesktopWindowInfo info) {
        this.logger.finest("DesktopWindow updated: windowId=" + info.getWindowID());
        this.waitState.onDesktopWindowUpdated(info);
    }

    public void onDesktopWindowClosed(DesktopWmProtos.DesktopWindowInfo info) {
        this.logger.finest("DesktopWindow closed: windowId=" + info.getWindowID());
        this.waitState.onDesktopWindowClosed(info);
    }

    public void onDesktopWindowActivated(DesktopWmProtos.DesktopWindowInfo info) {
        this.logger.finest("DesktopWindow active: windowId=" + info.getWindowID());
        this.waitState.onDesktopWindowActivated(info);
    }

    public void onDesktopWindowLoaded(DesktopWmProtos.DesktopWindowInfo info) {
        this.logger.finest("DesktopWindow loaded: windowId=" + info.getWindowID());
        this.waitState.onDesktopWindowLoaded(info);
    }

    public void onDesktopWindowPageChanged(DesktopWmProtos.DesktopWindowInfo info) {
        this.logger.fine("DesktopWindow page changed: windowId=" + info.getWindowID());
        this.waitState.onDesktopWindowPageChanged(info);
    }

    public void onQuickMenuShown(DesktopWmProtos.QuickMenuInfo info) {
        this.logger.finest("QuickMenu shown: menuName=" + info.getMenuId().getMenuName());
        this.waitState.onQuickMenuShown(info);
    }

    public void onQuickMenuItemPressed(DesktopWmProtos.QuickMenuItemID menuItemID) {
        this.logger.finest("QuickMenu shown: menuItem=" + menuItemID.getMenuText());
        this.waitState.onQuickMenuItemPressed(menuItemID);
    }

    public void onQuickMenuClosed(DesktopWmProtos.QuickMenuID id) {
        this.logger.finest("QuickMenu closed");
        this.waitState.onQuickMenuClosed(id);
    }

    @Override
    public void onHandshake(boolean stp1) {
        this.logger.finest("Got Stp handshake!");
        this.waitState.onHandshake();
    }

    @Override
    public void onDisconnect() {
        this.logger.fine("Disconnected, closing STP connection");
        if (this.isConnected() && !this.shutdown) {
            this.waitState.onDisconnected();
            this.connection = null;
        }
    }

    public void onOperaIdle() {
        this.logger.finest("idle: Got idle event");
        this.waitState.onOperaIdle();
    }

    public void onSelftestDone() {
        this.waitState.onSelftestDone();
    }

    public void waitForWindowLoaded(int activeWindowId, long timeout) {
        this.waitState.waitForWindowLoaded(activeWindowId, timeout);
    }

    public WaitState waitFor() {
        return this.waitState;
    }

    public boolean isOperaIdleAvailable() {
        return this.services.containsKey((Object)ScopeService.CORE) && VersionUtil.compare(this.services.get((Object)ScopeService.CORE).getServiceVersion(), "1.1") >= 0;
    }

    public void captureOperaIdle() {
        this.logger.finer("idle: Capturing idle event");
        this.waitState.captureOperaIdle();
    }

    public void waitForOperaIdle(long timeout) {
        this.logger.finest("idle: Waiting for (timeout = " + timeout + ")");
        this.waitState.waitForOperaIdle(timeout);
        this.logger.finest("idle: Finished waiting");
    }

    public void waitStart() {
        this.waitState.setWaitEvents(true);
    }

    public int waitForDesktopWindowLoaded(String windowName, long timeout) {
        this.waitState.setWaitEvents(false);
        try {
            return this.waitState.waitForDesktopWindowLoaded(windowName, timeout);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int waitForDesktopWindowShown(String windowName, long timeout) {
        this.waitState.setWaitEvents(false);
        try {
            return this.waitState.waitForDesktopWindowShown(windowName, timeout);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int waitForDesktopWindowUpdated(String windowName, long timeout) {
        this.waitState.setWaitEvents(false);
        try {
            return this.waitState.waitForDesktopWindowUpdated(windowName, timeout);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int waitForDesktopWindowActivated(String windowName, long timeout) {
        this.waitState.setWaitEvents(false);
        try {
            return this.waitState.waitForDesktopWindowActivated(windowName, timeout);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int waitForDesktopWindowClosed(String windowName, long timeout) {
        this.waitState.setWaitEvents(false);
        try {
            return this.waitState.waitForDesktopWindowClosed(windowName, timeout);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int waitForDesktopWindowPageChanged(String windowName, long timeout) {
        this.waitState.setWaitEvents(false);
        try {
            return this.waitState.waitForWindowPageChanged(windowName, timeout);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String waitForMenuShown(String menuName, long timeout) {
        this.waitState.setWaitEvents(false);
        try {
            return this.waitState.waitForQuickMenuShown(menuName, timeout);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String waitForMenuClosed(String menuName, long timeout) {
        this.waitState.setWaitEvents(false);
        try {
            return this.waitState.waitForQuickMenuClosed(menuName, timeout);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String waitForMenuItemPressed(String menuItemText, long timeout) {
        this.waitState.setWaitEvents(false);
        try {
            return this.waitState.waitForQuickMenuItemPressed(menuItemText, timeout);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public void onResponseReceived(int tag, UmsProtos.Response response) {
        if (this.isConnected()) {
            this.logger.finest("Got response");
            if (response != null) {
                this.waitState.onResponse(tag, response);
            } else {
                this.waitState.onError(tag);
            }
        }
    }

    @Override
    public void onException(Exception exception) {
        if (this.isConnected()) {
            this.waitState.onException(exception);
            this.connection = null;
        }
    }

    private UmsProtos.Response waitForResponse(int tag, long timeout) {
        try {
            return this.waitState.waitFor(tag, timeout);
        }
        catch (CommunicationException e) {
            this.shutdown();
            throw e;
        }
    }

    public void close() {
        this.connection.close();
    }

    private UmsProtos.Command.Builder buildMessage(Message message, ByteString payload) {
        UmsProtos.Command.Builder cb = UmsProtos.Command.newBuilder();
        cb.setCommandID(message.getID());
        cb.setFormat(0);
        cb.setService(message.getServiceName());
        cb.setTag(this.tagCounter.incrementAndGet());
        cb.setPayload(payload);
        return cb;
    }

    public UmsProtos.Response executeMessage(Message message, AbstractMessage.Builder<?> builder) {
        return this.executeMessage(message, builder, OperaIntervals.RESPONSE_TIMEOUT.getMs());
    }

    public UmsProtos.Response executeMessage(Message message, AbstractMessage.Builder<?> builder, long timeout) {
        ByteString payload = builder != null ? builder.build().toByteString() : ByteString.EMPTY;
        UmsProtos.Command.Builder messageBuilder = this.buildMessage(message, payload);
        int tag = messageBuilder.getTag();
        this.connection.send(messageBuilder.build());
        return this.waitForResponse(tag, timeout);
    }

    public void startStpThread() {
        this.stpThread.start();
    }

    public void onRequest(int windowId) {
        this.logger.fine("Window closed: windowId=" + windowId);
        this.waitState.onRequest(windowId);
    }

    public StpConnection getConnection() {
        return this.connection;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public void setDebugger(EcmascriptDebugger debugger) {
        this.debugger = debugger;
    }

    public Exec getExec() {
        return this.exec;
    }

    public void setExec(Exec exec) {
        this.exec = exec;
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    public void setWindowManager(WindowManager windowManager) {
        this.windowManager = windowManager;
    }

    public ConsoleLogger getConsoleLogger() {
        return this.consoleLogger;
    }

    public void setConsoleLogger(ConsoleLogger consoleLogger) {
        this.consoleLogger = consoleLogger;
    }

    public Core getCore() {
        return this.core;
    }

    public void setCore(Core core) {
        this.core = core;
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public DesktopWindowManager getDesktopWindowManager() {
        return this.desktopWindowManager;
    }

    public void setDesktopWindowManager(DesktopWindowManager desktopWindowManager) {
        this.desktopWindowManager = desktopWindowManager;
    }

    public DesktopUtils getDesktopUtils() {
        return this.desktopUtils;
    }

    public void setDesktopUtils(DesktopUtils desktopUtils) {
        this.desktopUtils = desktopUtils;
    }

    public ScopeSystemInputManager getSystemInputManager() {
        return this.systemInputManager;
    }

    public void setSystemInputManager(ScopeSystemInputManager manager) {
        this.systemInputManager = manager;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public void setCookieManager(CookieManager cookieManager) {
        this.cookieManager = cookieManager;
    }

    public Selftest getSelftest() {
        return this.selftest;
    }

    public void setSelftest(Selftest selftest) {
        this.selftest = selftest;
    }
}

