/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLDocument;
import com.gargoylesoftware.htmlunit.xml.XmlPage;

@JsxClass
public class DOMImplementation
extends SimpleScriptable {
    @JsxFunction
    public boolean hasFeature(String feature, String version) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_35)) {
            if ("HTML".equals(feature) && "1.0".equals(version)) {
                return true;
            }
        } else {
            if ("HTML".equals(feature) && ("1.0".equals(version) || "2.0".equals(version))) {
                return true;
            }
            if ("XML".equals(feature) && ("1.0".equals(version) || "2.0".equals(version))) {
                return true;
            }
            if ("CSS2".equals(feature) && "2.0".equals(version)) {
                return true;
            }
            if ("XPath".equals(feature) && "3.0".equals(version)) {
                return true;
            }
        }
        return false;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public XMLDocument createDocument(String namespaceURI, String qualifiedName, Object doctype) {
        XMLDocument document = new XMLDocument(this.getWindow().getWebWindow());
        document.setParentScope(this.getParentScope());
        document.setPrototype(this.getPrototype(document.getClass()));
        if (qualifiedName != null && !qualifiedName.isEmpty()) {
            XmlPage page = (XmlPage)document.getDomNodeOrDie();
            page.appendChild(page.createXmlElementNS(namespaceURI, qualifiedName));
        }
        return document;
    }
}

