/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.interactions.touch;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.HasTouchScreen;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.TouchScreen;
import org.openqa.selenium.interactions.touch.DoubleTapAction;
import org.openqa.selenium.interactions.touch.DownAction;
import org.openqa.selenium.interactions.touch.FlickAction;
import org.openqa.selenium.interactions.touch.LongPressAction;
import org.openqa.selenium.interactions.touch.MoveAction;
import org.openqa.selenium.interactions.touch.ScrollAction;
import org.openqa.selenium.interactions.touch.SingleTapAction;
import org.openqa.selenium.interactions.touch.UpAction;
import org.openqa.selenium.internal.Locatable;

public class TouchActions
extends Actions {
    protected TouchScreen touchScreen;

    public TouchActions(WebDriver driver) {
        this(((HasInputDevices)driver).getKeyboard(), ((HasTouchScreen)driver).getTouch());
    }

    public TouchActions(Keyboard keyboard, TouchScreen touchScreen) {
        super(keyboard);
        this.touchScreen = touchScreen;
    }

    public TouchActions singleTap(WebElement onElement) {
        this.action.addAction(new SingleTapAction(this.touchScreen, (Locatable)onElement));
        return this;
    }

    public TouchActions down(int x, int y) {
        this.action.addAction(new DownAction(this.touchScreen, x, y));
        return this;
    }

    public TouchActions up(int x, int y) {
        this.action.addAction(new UpAction(this.touchScreen, x, y));
        return this;
    }

    public TouchActions move(int x, int y) {
        this.action.addAction(new MoveAction(this.touchScreen, x, y));
        return this;
    }

    public TouchActions scroll(WebElement onElement, int xOffset, int yOffset) {
        this.action.addAction(new ScrollAction(this.touchScreen, (Locatable)onElement, xOffset, yOffset));
        return this;
    }

    public TouchActions doubleTap(WebElement onElement) {
        this.action.addAction(new DoubleTapAction(this.touchScreen, (Locatable)onElement));
        return this;
    }

    public TouchActions longPress(WebElement onElement) {
        this.action.addAction(new LongPressAction(this.touchScreen, (Locatable)onElement));
        return this;
    }

    public TouchActions scroll(int xOffset, int yOffset) {
        this.action.addAction(new ScrollAction(this.touchScreen, xOffset, yOffset));
        return this;
    }

    public TouchActions flick(int xSpeed, int ySpeed) {
        this.action.addAction(new FlickAction(this.touchScreen, xSpeed, ySpeed));
        return this;
    }

    public TouchActions flick(WebElement onElement, int xOffset, int yOffset, int speed) {
        this.action.addAction(new FlickAction(this.touchScreen, (Locatable)onElement, xOffset, yOffset, speed));
        return this;
    }
}

