/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.nio.charset.Charset;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import org.openqa.selenium.safari.SafariDriverConnection;
import org.openqa.selenium.safari.WebSocketConnection;

class SafariDriverChannelHandler
extends SimpleChannelUpstreamHandler {
    private final Logger log = Logger.getLogger(SafariDriverChannelHandler.class.getName());
    private static final String CONNECT_TEMPLATE = Joiner.on((String)"\n").join((Object)"<!DOCTYPE html>", (Object)"<h2>SafariDriver requesting connection at ws://localhost:%d</h2>", new Object[]{"<script>", "// Must wait for onload so the injected script is loaded by the", "// SafariDriver extension", "window.onload = function() {", "  window.postMessage({", "    'type': 'connect',", "    'origin': 'webdriver',", "    'url': 'ws://localhost:%d'", "  }, '*');", "};", "</script>"});
    private final BlockingQueue<SafariDriverConnection> connectionQueue;
    private final UUID id;
    private final int port;
    private volatile SafariDriverConnection connection;
    private WebSocketServerHandshaker handshaker;

    public SafariDriverChannelHandler(int port, BlockingQueue<SafariDriverConnection> connectionQueue) {
        this.port = port;
        this.id = UUID.randomUUID();
        this.connectionQueue = connectionQueue;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (e.getMessage() instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)e.getMessage();
            if ("websocket".equalsIgnoreCase(request.getHeader("Upgrade"))) {
                this.performWebSocketHandshake(ctx, request);
                return;
            }
            List connectionHeaders = request.getHeaders("Connection");
            for (String header : connectionHeaders) {
                if (!"upgrade".equalsIgnoreCase(header)) continue;
                this.performWebSocketHandshake(ctx, request);
                return;
            }
            if (request.getMethod() != HttpMethod.GET && request.getMethod() != HttpMethod.HEAD) {
                this.sendNotAllowedResponse(ctx, request, HttpMethod.GET, HttpMethod.HEAD);
            } else if ("/favicon.ico".equals(request.getUri())) {
                this.handleFaviconRequest(ctx, request);
            } else {
                this.handleMainPageRequest(ctx, request);
            }
        } else if (e.getMessage() instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)e.getMessage());
        } else {
            super.messageReceived(ctx, e);
        }
    }

    private void handleFaviconRequest(ChannelHandlerContext ctx, HttpRequest request) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NO_CONTENT);
        response.setHeader("Content-Length", (Object)0);
        this.sendResponse(ctx, request, (HttpResponse)response);
    }

    private void handleMainPageRequest(ChannelHandlerContext ctx, HttpRequest request) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setHeader("Content-Type", (Object)"text/html; charset=UTF-8");
        String content = String.format(CONNECT_TEMPLATE, this.port, this.port);
        response.setContent(ChannelBuffers.copiedBuffer((CharSequence)content, (Charset)Charsets.UTF_8));
        response.setHeader("Content-Length", (Object)response.getContent().readableBytes());
        this.sendResponse(ctx, request, (HttpResponse)response);
    }

    private void performWebSocketHandshake(final ChannelHandlerContext ctx, HttpRequest request) {
        this.log.fine("Performing WebSocket handshake");
        if (request.getMethod() != HttpMethod.GET) {
            this.log.fine("Invalid handshake method: " + request.getMethod() + "; must be GET");
            this.sendNotAllowedResponse(ctx, request, HttpMethod.GET);
            return;
        }
        String websocketUrl = String.format("ws://%s%s", request.getHeader("Host"), request.getUri());
        String noSubProtocols = null;
        boolean noExtensions = false;
        WebSocketServerHandshakerFactory handshakerFactory = new WebSocketServerHandshakerFactory(websocketUrl, noSubProtocols, noExtensions);
        this.handshaker = handshakerFactory.newHandshaker(request);
        if (this.handshaker == null) {
            handshakerFactory.sendUnsupportedWebSocketVersionResponse(ctx.getChannel());
        } else {
            this.handshaker.handshake(ctx.getChannel(), request).addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        SafariDriverChannelHandler.this.log.warning("WebSocket handshake failed");
                        return;
                    }
                    SafariDriverChannelHandler.this.log.info("Connection opened");
                    WebSocketConnection webSocketConnection = new WebSocketConnection(ctx.getChannel());
                    SafariDriverChannelHandler.this.connection = new SafariDriverConnection(webSocketConnection);
                    try {
                        SafariDriverChannelHandler.this.connectionQueue.put(SafariDriverChannelHandler.this.connection);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    private void sendNotAllowedResponse(ChannelHandlerContext ctx, HttpRequest request, HttpMethod ... allowedMethods) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED);
        response.setHeader("Allow", (Object)Joiner.on((String)",").join((Object[])allowedMethods));
        response.setHeader("Content-Length", (Object)0);
        this.sendResponse(ctx, request, (HttpResponse)response);
    }

    private void sendResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        ChannelFuture future = ctx.getChannel().write((Object)response);
        if (!HttpHeaders.isKeepAlive((HttpMessage)request) || response.getStatus().getCode() != 200) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.log.fine("Socket closed by client");
            this.handshaker.close(ctx.getChannel(), (CloseWebSocketFrame)frame);
        } else if (frame instanceof PingWebSocketFrame) {
            ctx.getChannel().write((Object)new PongWebSocketFrame(frame.getBinaryData()));
        } else {
            Preconditions.checkState((boolean)(frame instanceof TextWebSocketFrame));
            Preconditions.checkState((this.connection != null ? 1 : 0) != 0);
            TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
            this.log.fine("Received message: " + textFrame.getText());
            this.connection.onMessage(textFrame.getText());
        }
    }
}

