/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.service;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.service.DriverService;

public class DriverCommandExecutor
extends HttpCommandExecutor {
    private final DriverService service;

    public DriverCommandExecutor(DriverService service) {
        super((URL)Require.nonNull((String)"DriverService", (Object)service.getUrl()));
        this.service = service;
    }

    protected DriverCommandExecutor(DriverService service, Map<String, CommandInfo> additionalCommands) {
        super(additionalCommands, service.getUrl());
        this.service = service;
    }

    @Override
    public Response execute(Command command) throws IOException {
        if ("newSession".equals(command.getName())) {
            this.service.start();
        }
        if ("quit".equals(command.getName())) {
            CompletableFuture<Response> commandComplete = CompletableFuture.supplyAsync(() -> {
                try {
                    return super.execute(command);
                }
                catch (Throwable t) {
                    Throwable rootCause = Throwables.getRootCause((Throwable)t);
                    if (rootCause instanceof IllegalStateException && "Closed".equals(rootCause.getMessage())) {
                        return null;
                    }
                    if (rootCause instanceof ConnectException && "Connection refused".equals(rootCause.getMessage())) {
                        throw new WebDriverException("The driver server has unexpectedly died!", t);
                    }
                    Throwables.throwIfUnchecked((Throwable)t);
                    throw new WebDriverException(t);
                }
            });
            CompletableFuture<Response> processFinished = CompletableFuture.supplyAsync(() -> {
                this.service.process.waitFor(this.service.getTimeout().toMillis());
                return null;
            });
            try {
                Response response = (Response)CompletableFuture.anyOf(commandComplete, processFinished).get(this.service.getTimeout().toMillis() * 2L, TimeUnit.MILLISECONDS);
                this.service.stop();
                return response;
            }
            catch (ExecutionException | TimeoutException e) {
                throw new WebDriverException("Timed out waiting for driver server to stop.", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WebDriverException("Timed out waiting for driver server to stop.", (Throwable)e);
            }
        }
        try {
            return super.execute(command);
        }
        catch (Throwable t) {
            Throwable rootCause = Throwables.getRootCause((Throwable)t);
            if (rootCause instanceof ConnectException && "Connection refused".equals(rootCause.getMessage()) && !this.service.isRunning()) {
                throw new WebDriverException("The driver server has unexpectedly died!", t);
            }
            Throwables.throwIfUnchecked((Throwable)t);
            throw new WebDriverException(t);
        }
    }
}

