/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.json.JsonInput;

public class Console {
    private Console() {
    }

    public static Command<Void> enable() {
        return new Command<Void>("Console.enable", (Map<String, Object>)ImmutableMap.of());
    }

    public static Event<ConsoleMessage> messageAdded() {
        return new Event<ConsoleMessage>("Console.messageAdded", ConverterFunctions.map("message", ConsoleMessage.class));
    }

    public static class ConsoleMessage {
        private final String source;
        private final String level;
        private final String text;

        public ConsoleMessage(String source, String level, String text) {
            this.source = Objects.requireNonNull(source);
            this.level = Objects.requireNonNull(level);
            this.text = Objects.requireNonNull(text);
        }

        private static ConsoleMessage fromJson(JsonInput input) {
            String source = null;
            String level = null;
            String text = null;
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "level": {
                        level = input.nextString();
                        continue block10;
                    }
                    case "source": {
                        source = input.nextString();
                        continue block10;
                    }
                    case "text": {
                        text = input.nextString();
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new ConsoleMessage(source, level, text);
        }

        public String toString() {
            return new StringJoiner(", ", ConsoleMessage.class.getSimpleName() + "[", "]").add("level='" + this.level + "'").add("source='" + this.source + "'").add("text='" + this.text + "'").toString();
        }
    }
}

