/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.log;

import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.openqa.selenium.grid.log.TerseFormatter;
import org.openqa.selenium.remote.server.log.MaxLevelFilter;
import org.openqa.selenium.remote.server.log.PerSessionLogHandler;
import org.openqa.selenium.remote.server.log.StdOutHandler;

public class LoggingManager {
    private static PerSessionLogHandler perSessionLogHandler = new PerSessionLogHandler(4000, (Formatter)new TerseFormatter(), false);

    public static synchronized void configureLogging(boolean debugMode) {
        Logger currentLogger = Logger.getLogger("");
        LoggingManager.overrideSimpleFormatterWithTerseOneForConsoleHandler(currentLogger, debugMode);
        if (debugMode) {
            currentLogger.setLevel(Level.FINE);
        }
    }

    public static synchronized PerSessionLogHandler perSessionLogHandler() {
        return perSessionLogHandler;
    }

    public static void overrideSimpleFormatterWithTerseOneForConsoleHandler(Logger logger, boolean debugMode) {
        for (Handler handler : logger.getHandlers()) {
            Formatter formatter;
            if (!(handler instanceof ConsoleHandler) || !((formatter = handler.getFormatter()) instanceof SimpleFormatter)) continue;
            Level originalLevel = handler.getLevel();
            handler.setFormatter((Formatter)new TerseFormatter());
            handler.setLevel(Level.WARNING);
            StdOutHandler stdOutHandler = new StdOutHandler();
            stdOutHandler.setFormatter((Formatter)new TerseFormatter());
            stdOutHandler.setFilter(new MaxLevelFilter(Level.INFO));
            stdOutHandler.setLevel(originalLevel);
            logger.addHandler(stdOutHandler);
            if (!debugMode || originalLevel.intValue() <= Level.FINE.intValue()) continue;
            stdOutHandler.setLevel(Level.FINE);
        }
    }
}

