/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.jmx;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.openqa.selenium.grid.jmx.ManagedAttribute;
import org.openqa.selenium.grid.jmx.ManagedOperation;
import org.openqa.selenium.grid.jmx.ManagedService;

public class MBean
implements DynamicMBean {
    private final Object bean;
    private final MBeanInfo beanInfo;
    private final Map<String, AttributeInfo> attributeMap = new HashMap<String, AttributeInfo>();
    private final Map<String, OperationInfo> operationMap = new HashMap<String, OperationInfo>();
    private final ObjectName objectName;

    MBean(Object bean) {
        this.bean = bean;
        ManagedService mBean = bean.getClass().getAnnotation(ManagedService.class);
        if (mBean == null) {
            throw new IllegalArgumentException(String.format("%s has no @ManagedService annotation", bean.getClass().getName()));
        }
        String name = bean.getClass().getName();
        String description = mBean.description();
        this.collectAttributeInfo(bean);
        MBeanAttributeInfo[] attributes = (MBeanAttributeInfo[])this.attributeMap.values().stream().map(AttributeInfo::getMBeanAttributeInfo).toArray(MBeanAttributeInfo[]::new);
        this.collectOperationInfo(bean);
        MBeanOperationInfo[] operations = (MBeanOperationInfo[])this.operationMap.values().stream().map(OperationInfo::getMBeanOperationInfo).toArray(MBeanOperationInfo[]::new);
        this.beanInfo = new MBeanInfo(name, description, attributes, null, operations, null);
        this.objectName = this.generateObjectName(bean);
    }

    private void collectAttributeInfo(Object bean) {
        Stream.of(bean.getClass().getMethods()).map(this::getAttributeInfo).filter(Objects::nonNull).forEach(ai -> this.attributeMap.put(ai.name, (AttributeInfo)ai));
    }

    private AttributeInfo getAttributeInfo(Method m) {
        ManagedAttribute ma = m.getAnnotation(ManagedAttribute.class);
        if (ma == null) {
            return null;
        }
        try {
            String name = "".equals(ma.name()) ? m.getName() : ma.name();
            return new AttributeInfo(name, ma.description(), this.findGetter(m), this.findSetter(m));
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private Method findGetter(Method annotatedMethod) {
        ManagedAttribute ma = annotatedMethod.getAnnotation(ManagedAttribute.class);
        try {
            if (!"".equals(ma.getter())) {
                return annotatedMethod.getDeclaringClass().getMethod(ma.getter(), new Class[0]);
            }
            String name = annotatedMethod.getName();
            if (name.startsWith("get") || name.startsWith("is")) {
                return annotatedMethod;
            }
            if (name.startsWith("set")) {
                return annotatedMethod.getDeclaringClass().getMethod("g" + name.substring(1), new Class[0]);
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Method findSetter(Method annotatedMethod) {
        ManagedAttribute ma = annotatedMethod.getAnnotation(ManagedAttribute.class);
        if (!"".equals(ma.setter())) {
            return this.findMethod(annotatedMethod.getDeclaringClass(), ma.setter());
        }
        String name = annotatedMethod.getName();
        if (name.startsWith("set")) {
            return annotatedMethod;
        }
        if (name.startsWith("get")) {
            this.findMethod(annotatedMethod.getDeclaringClass(), "s" + name.substring(1));
        }
        if (name.startsWith("is")) {
            this.findMethod(annotatedMethod.getDeclaringClass(), "set" + name.substring(2));
        }
        return null;
    }

    private Method findMethod(Class<?> cls, String name) {
        return Stream.of(cls.getMethods()).filter(m -> m.getName().equals(name)).findFirst().orElse(null);
    }

    private void collectOperationInfo(Object bean) {
        Stream.of(bean.getClass().getMethods()).map(this::getOperationInfo).filter(Objects::nonNull).forEach(oi -> this.operationMap.put(oi.name, (OperationInfo)oi));
    }

    private OperationInfo getOperationInfo(Method m) {
        ManagedOperation mo = m.getAnnotation(ManagedOperation.class);
        if (mo == null) {
            return null;
        }
        return new OperationInfo(m.getName(), mo.description(), m);
    }

    private ObjectName generateObjectName(Object bean) {
        ManagedService mBean = bean.getClass().getAnnotation(ManagedService.class);
        try {
            String name = mBean.objectName();
            if ("".equals(name)) {
                try {
                    return (ObjectName)bean.getClass().getMethod("getObjectName", new Class[0]).invoke(bean, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    return new ObjectName(String.format("%s:type=%s", bean.getClass().getPackage().getName(), bean.getClass().getSimpleName()));
                }
            }
            return new ObjectName(mBean.objectName());
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Cannot generate ObjectName for a bean", e);
        }
    }

    @Override
    public Object getAttribute(String attribute) {
        try {
            Object res = this.attributeMap.get((Object)attribute).getter.invoke(this.bean, new Object[0]);
            if (res instanceof Map) {
                return ((Map)res).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
            }
            return res.toString();
        }
        catch (IllegalAccessException | InvocationTargetException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    @Override
    public void setAttribute(Attribute attribute) {
        try {
            this.attributeMap.get((Object)attribute.getName()).setter.invoke(this.bean, attribute.getValue());
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        return null;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) {
        try {
            return this.operationMap.get((Object)actionName).method.invoke(this.bean, params);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.beanInfo;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    private static class OperationInfo {
        final String name;
        final String description;
        final Method method;

        OperationInfo(String name, String description, Method method) {
            this.name = name;
            this.description = description;
            this.method = method;
        }

        MBeanOperationInfo getMBeanOperationInfo() {
            return new MBeanOperationInfo(this.description, this.method);
        }
    }

    private static class AttributeInfo {
        final String name;
        final String description;
        final Method getter;
        final Method setter;

        AttributeInfo(String name, String description, Method getter, Method setter) {
            this.name = name;
            this.description = description;
            this.getter = getter;
            this.setter = setter;
        }

        MBeanAttributeInfo getMBeanAttributeInfo() {
            try {
                return new MBeanAttributeInfo(this.name, this.description, this.getter, this.setter);
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

