/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;

public class ConfigureTimeout
extends WebDriverHandler<Void> {
    private static final String IMPLICIT = "implicit";
    private static final String PAGE_LOAD = "page load";
    private static final String SCRIPT = "script";
    private static final List<String> knownTypes = Arrays.asList("implicit", "page load", "script");
    private Map<String, Object> timeouts = new HashMap<String, Object>();

    public ConfigureTimeout(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        super.setJsonParameters(allParameters);
        String type = (String)allParameters.get("type");
        if (type != null) {
            if (!knownTypes.contains(type)) {
                throw new WebDriverException("Unknown wait type: " + type);
            }
            this.timeouts.put(type, allParameters.get("ms"));
        } else {
            for (String key : allParameters.keySet()) {
                if (knownTypes.contains(key)) continue;
                throw new WebDriverException("Unknown wait type: " + key);
            }
            this.timeouts.putAll(allParameters);
        }
    }

    @Override
    public Void call() {
        if (this.timeouts.containsKey(IMPLICIT)) {
            try {
                this.getDriver().manage().timeouts().implicitlyWait(Duration.ofMillis(((Number)this.timeouts.get(IMPLICIT)).longValue()));
            }
            catch (ClassCastException ex) {
                throw new WebDriverException("Illegal (non-numeric) timeout value passed: " + this.timeouts.get(IMPLICIT), (Throwable)ex);
            }
        }
        if (this.timeouts.containsKey(PAGE_LOAD)) {
            try {
                this.getDriver().manage().timeouts().pageLoadTimeout(Duration.ofMillis(((Number)this.timeouts.get(PAGE_LOAD)).longValue()));
            }
            catch (ClassCastException ex) {
                throw new WebDriverException("Illegal (non-numeric) timeout value passed: " + this.timeouts.get(PAGE_LOAD), (Throwable)ex);
            }
        }
        if (this.timeouts.containsKey(SCRIPT)) {
            try {
                this.getDriver().manage().timeouts().setScriptTimeout(Duration.ofMillis(((Number)this.timeouts.get(SCRIPT)).longValue()));
            }
            catch (ClassCastException ex) {
                throw new WebDriverException("Illegal (non-numeric) timeout value passed: " + this.timeouts.get(SCRIPT), (Throwable)ex);
            }
        }
        return null;
    }

    public String toString() {
        return "[" + this.timeouts.entrySet().stream().map(entry -> String.format("%s: %s", entry.getKey(), entry.getValue())).collect(Collectors.joining(",")) + "]";
    }
}

