/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.web.CheckContentTypeHeader;
import org.openqa.selenium.grid.web.CheckOriginHeader;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.tracing.TracedHttpClient;
import org.openqa.selenium.remote.tracing.Tracer;

public class NetworkOptions {
    private static final String NETWORK_SECTION = "network";
    private final Config config;
    private final Set<String> SKIP_CHECKS_ON = ImmutableSet.of((Object)"/status", (Object)"/readyz");

    public NetworkOptions(Config config) {
        this.config = (Config)Require.nonNull((String)"Config", (Object)config);
    }

    public HttpClient.Factory getHttpClientFactory(Tracer tracer) {
        return new TracedHttpClient.Factory(tracer, HttpClient.Factory.createDefault());
    }

    public Filter getSpecComplianceChecks() {
        Filter toReturn = httpHandler -> httpHandler;
        if (this.config.getBool(NETWORK_SECTION, "relax-checks").orElse(false).booleanValue()) {
            return toReturn;
        }
        if (this.config.getBool(NETWORK_SECTION, "check_content_type").orElse(true).booleanValue()) {
            toReturn = toReturn.andThen((Filter)new CheckContentTypeHeader(this.SKIP_CHECKS_ON));
        }
        boolean checkOrigin = this.config.getBool(NETWORK_SECTION, "check_origin_header").orElse(true);
        Optional<List<String>> allowedOrigins = this.config.getAll(NETWORK_SECTION, "allowed_origins");
        if (checkOrigin || allowedOrigins.isPresent()) {
            toReturn = toReturn.andThen((Filter)new CheckOriginHeader((Collection<String>)allowedOrigins.orElse((List<String>)ImmutableList.of()), this.SKIP_CHECKS_ON));
        }
        return toReturn;
    }
}

