/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import java.util.UUID;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;

public class SlotId {
    private final NodeId nodeId;
    private final UUID uuid;

    public SlotId(NodeId host, UUID uuid) {
        this.nodeId = (NodeId)Require.nonNull((String)"Host id", (Object)host);
        this.uuid = (UUID)Require.nonNull((String)"Actual id", (Object)uuid);
    }

    public NodeId getOwningNodeId() {
        return this.nodeId;
    }

    public UUID getSlotId() {
        return this.uuid;
    }

    public String toString() {
        return "SlotId{nodeId=" + this.nodeId + ", id=" + this.uuid + '}';
    }

    public boolean equals(Object o) {
        if (!(o instanceof SlotId)) {
            return false;
        }
        SlotId that = (SlotId)o;
        return Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.nodeId, this.uuid);
    }

    private Object toJson() {
        return ImmutableMap.of((Object)"hostId", (Object)this.nodeId, (Object)"id", (Object)this.uuid);
    }

    private static SlotId fromJson(JsonInput input) {
        NodeId nodeId = null;
        UUID id = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "hostId": {
                    nodeId = (NodeId)input.read(NodeId.class);
                    continue block8;
                }
                case "id": {
                    id = (UUID)input.read(UUID.class);
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SlotId(nodeId, id);
    }
}

