/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.commandhandler;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.grid.session.ActiveSession;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.log.LoggingManager;

public class GetLogsOfType
implements HttpHandler {
    private final Json json;
    private final ActiveSession session;

    public GetLogsOfType(Json json, ActiveSession session) {
        this.json = Objects.requireNonNull(json);
        this.session = Objects.requireNonNull(session);
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        String originalPayload = Contents.string((HttpMessage)req);
        Map args = (Map)this.json.toType(originalPayload, Json.MAP_TYPE);
        String type = (String)args.get("type");
        if (!"server".equals(type)) {
            HttpRequest upReq = new HttpRequest(HttpMethod.POST, String.format("/session/%s/log", this.session.getId()));
            upReq.setContent(Contents.utf8String((CharSequence)originalPayload));
            return this.session.execute(upReq);
        }
        LogEntries entries = null;
        try {
            entries = LoggingManager.perSessionLogHandler().getSessionLog(this.session.getId());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Response response = new Response(this.session.getId());
        response.setStatus(Integer.valueOf(0));
        response.setValue((Object)entries);
        HttpResponse resp = new HttpResponse();
        this.session.getDownstreamDialect().getResponseCodec().encode(() -> resp, response);
        return resp;
    }
}

