/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.collect.ImmutableSet;
import io.opentelemetry.context.Scope;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.Tracer;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.logging.Logger;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;

public class ReverseProxyHandler
implements HttpHandler {
    private static final Logger LOG = Logger.getLogger(ReverseProxyHandler.class.getName());
    private static final ImmutableSet<String> IGNORED_REQ_HEADERS = ImmutableSet.builder().add((Object)"connection").add((Object)"keep-alive").add((Object)"proxy-authorization").add((Object)"proxy-authenticate").add((Object)"proxy-connection").add((Object)"te").add((Object)"trailer").add((Object)"transfer-encoding").add((Object)"upgrade").build();
    private final Tracer tracer;
    private final HttpClient upstream;

    public ReverseProxyHandler(Tracer tracer, HttpClient httpClient) {
        this.tracer = Objects.requireNonNull(tracer, "Tracer must be set.");
        this.upstream = Objects.requireNonNull(httpClient, "HTTP client to use must be set.");
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        Span span = HttpTracing.newSpanAsChildOf((Tracer)this.tracer, (HttpRequest)req, (String)"reverse_proxy").startSpan();
        try {
            HttpResponse httpResponse;
            block13: {
                Scope scope = this.tracer.withSpan(span);
                try {
                    span.setAttribute("http.method", req.getMethod().toString());
                    span.setAttribute("http.url", req.getUri());
                    HttpRequest toUpstream = new HttpRequest(req.getMethod(), req.getUri());
                    for (String name : req.getQueryParameterNames()) {
                        for (String value : req.getQueryParameters(name)) {
                            toUpstream.addQueryParameter(name, value);
                        }
                    }
                    for (String name : req.getHeaderNames()) {
                        if (IGNORED_REQ_HEADERS.contains((Object)name.toLowerCase())) continue;
                        for (String value : req.getHeaders(name)) {
                            toUpstream.addHeader(name, value);
                        }
                    }
                    toUpstream.setHeader("Connection", "keep-alive");
                    toUpstream.setContent(req.getContent());
                    HttpResponse resp = this.upstream.execute(toUpstream);
                    span.setAttribute("http.status", (long)resp.getStatus());
                    resp.removeHeader("Date");
                    resp.removeHeader("Server");
                    IGNORED_REQ_HEADERS.forEach(x$0 -> {
                        HttpResponse cfr_ignored_0 = (HttpResponse)resp.removeHeader(x$0);
                    });
                    httpResponse = resp;
                    if (scope == null) break block13;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                scope.close();
            }
            return httpResponse;
        }
        finally {
            span.end();
        }
    }
}

