/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.net.HostIdentifier;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.net.PortProber;

public class BaseServerOptions {
    private static final Logger LOG = Logger.getLogger(BaseServerOptions.class.getName());
    private final Config config;
    private int port = -1;

    public BaseServerOptions(Config config) {
        this.config = config;
    }

    public Optional<String> getHostname() {
        return this.config.get("server", "hostname");
    }

    public int getPort() {
        if (this.port != -1) {
            return this.port;
        }
        int port = this.config.getInt("server", "port").orElseGet(PortProber::findFreePort);
        if (port < 0) {
            throw new ConfigException("Port cannot be less than 0: " + port, new Object[0]);
        }
        this.port = port;
        return port;
    }

    public int getMaxServerThreads() {
        int count = this.config.getInt("server", "max-threads").orElse(200);
        if (count < 0) {
            throw new ConfigException("Maximum number of server threads cannot be less than 0: " + count, new Object[0]);
        }
        return count;
    }

    public URI getExternalUri() {
        String host = this.getHostname().orElseGet(() -> {
            try {
                return new NetworkUtils().getNonLoopbackAddressOfThisMachine();
            }
            catch (WebDriverException e) {
                String name = HostIdentifier.getHostName();
                LOG.info("No network connection, guessing name: " + name);
                return name;
            }
        });
        int port = this.getPort();
        try {
            return new URI(this.isSecure() ? "https" : "http", null, host, port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new ConfigException("Cannot determine external URI: " + e.getMessage(), new Object[0]);
        }
    }

    public boolean getAllowCORS() {
        return this.config.getBool("server", "allow-cors").orElse(false);
    }

    public boolean isSecure() {
        return this.config.get("server", "https-private-key").isPresent() && this.config.get("server", "https-certificate").isPresent();
    }

    public File getPrivateKey() {
        String privateKey = this.config.get("server", "https-private-key").orElse(null);
        if (privateKey != null) {
            return new File(privateKey);
        }
        throw new ConfigException("you must provide a private key via --https-private-key when using --https", new Object[0]);
    }

    public File getCertificate() {
        String certificatePath = this.config.get("server", "https-certificate").orElse(null);
        if (certificatePath != null) {
            return new File(certificatePath);
        }
        throw new ConfigException("you must provide a certificate via --https-certificate when using --https", new Object[0]);
    }

    public String getRegistrationSecret() {
        return this.config.get("server", "registration-secret").orElse(null);
    }

    public boolean isSelfSigned() {
        return this.config.getBool("server", "https-self-signed").orElse(false);
    }
}

