/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.log;

import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.lang.reflect.Method;

class JaegerTracing {
    JaegerTracing() {
    }

    static SpanExporter findJaegerExporter() {
        String host = System.getProperty("JAEGER_AGENT_HOST");
        if (host == null) {
            return null;
        }
        String rawPort = System.getProperty("JAEGER_AGENT_PORT", "14250");
        int port = -1;
        try {
            port = Integer.parseInt(rawPort);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        if (port == -1) {
            return null;
        }
        try {
            Object jaegerChannel = JaegerTracing.createManagedChannel(host, port);
            SpanExporter toReturn = (SpanExporter)JaegerTracing.createJaegerGrpcSpanExporter(jaegerChannel);
            if (toReturn != null) {
                System.out.printf("Attaching Jaeger tracing to %s:%s\n", host, port);
            }
            return toReturn;
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    private static Object createManagedChannel(String host, int port) throws ReflectiveOperationException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> builderClazz = Class.forName("io.grpc.ManagedChannelBuilder", true, cl);
        Method forAddress = builderClazz.getMethod("forAddress", String.class, Integer.TYPE);
        Object value = forAddress.invoke(null, host, port);
        Method usePlaintext = builderClazz.getMethod("usePlaintext", new Class[0]);
        value = usePlaintext.invoke(value, new Object[0]);
        Method build = builderClazz.getMethod("build", new Class[0]);
        return build.invoke(value, new Object[0]);
    }

    private static Object createJaegerGrpcSpanExporter(Object jaegerChannel) throws ReflectiveOperationException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> exporterClazz = Class.forName("io.opentelemetry.exporters.jaeger.JaegerGrpcSpanExporter", true, cl);
        Method newBuilder = exporterClazz.getMethod("newBuilder", new Class[0]);
        Object builderObj = newBuilder.invoke(exporterClazz, new Object[0]);
        Class<?> builderClazz = builderObj.getClass();
        Method setServiceName = builderClazz.getMethod("setServiceName", String.class);
        builderObj = setServiceName.invoke(builderObj, System.getProperty("JAEGER_SERVICE_NAME", "selenium"));
        Class<?> managedChannelClazz = Class.forName("io.grpc.ManagedChannel", true, cl);
        Method setChannel = builderClazz.getMethod("setChannel", managedChannelClazz);
        builderObj = setChannel.invoke(builderObj, jaegerChannel);
        Method setDeadline = builderClazz.getMethod("setDeadline", Long.TYPE);
        builderObj = setDeadline.invoke(builderObj, 3000);
        Method build = builderClazz.getMethod("build", new Class[0]);
        return build.invoke(builderObj, new Object[0]);
    }
}

