/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.remote.SessionId;

public class Session {
    private final SessionId id;
    private final URI uri;
    private final Capabilities capabilities;

    public Session(SessionId id, URI uri, Capabilities capabilities) {
        this.id = Objects.requireNonNull(id, "Session ID must be set.");
        this.uri = Objects.requireNonNull(uri, "Where the session is running must be set.");
        Objects.requireNonNull(capabilities, "Session capabilities must be set");
        this.capabilities = ImmutableCapabilities.copyOf((Capabilities)capabilities);
    }

    public SessionId getId() {
        return this.id;
    }

    public URI getUri() {
        return this.uri;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    private Map<String, Object> toJson() {
        return ImmutableMap.of((Object)"sessionId", (Object)this.getId().toString(), (Object)"capabilities", (Object)this.getCapabilities(), (Object)"uri", (Object)this.getUri());
    }

    private static Session fromJson(Map<String, Object> raw) throws URISyntaxException {
        SessionId id = new SessionId((String)raw.get("sessionId"));
        URI uri = new URI((String)raw.get("uri"));
        ImmutableCapabilities caps = new ImmutableCapabilities((Map)raw.get("capabilities"));
        return new Session(id, uri, (Capabilities)caps);
    }

    public boolean equals(Object that) {
        if (!(that instanceof Session)) {
            return false;
        }
        Session session = (Session)that;
        return Objects.equals(this.id, session.getId()) && Objects.equals(this.uri, session.getUri());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.uri);
    }
}

