/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.webdriven.commands;

import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.Wait;
import com.thoughtworks.selenium.webdriven.SeleneseCommand;
import com.thoughtworks.selenium.webdriven.Windows;
import org.openqa.selenium.WebDriver;

public class WaitForPopup
extends SeleneseCommand<Void> {
    private final Windows windows;
    private final Runnable sleepUntil;

    public WaitForPopup(Windows windows, Runnable sleepUntil) {
        this.windows = windows;
        this.sleepUntil = sleepUntil;
    }

    @Override
    protected Void handleSeleneseCommand(final WebDriver driver, final String windowID, String timeout) {
        this.sleepUntil.run();
        long millis = this.toLong(timeout);
        String current = driver.getWindowHandle();
        new Wait(){

            @Override
            public boolean until() {
                try {
                    WaitForPopup.this.windows.selectPopUp(driver, windowID);
                    return !"about:blank".equals(driver.getCurrentUrl());
                }
                catch (SeleniumException seleniumException) {
                    return false;
                }
            }
        }.wait(String.format("Timed out waiting for %s. Waited %s", windowID, timeout), millis);
        driver.switchTo().window(current);
        return null;
    }
}

