/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler.internal;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.server.KnownElements;

public class ResultConverter
implements Function<Object, Object> {
    private final KnownElements knownElements;

    public ResultConverter(KnownElements knownElements) {
        this.knownElements = knownElements;
    }

    public Object apply(Object result) {
        if (result instanceof WebElement) {
            String elementId = this.knownElements.add((WebElement)result);
            return ImmutableMap.of((Object)"ELEMENT", (Object)elementId);
        }
        if (result instanceof List) {
            List resultAsList = (List)result;
            return Lists.newArrayList((Iterable)Iterables.transform((Iterable)resultAsList, (Function)this));
        }
        if (result instanceof Map) {
            Map resultAsMap = (Map)result;
            HashMap converted = new HashMap(resultAsMap.size());
            for (Map.Entry entry : resultAsMap.entrySet()) {
                converted.put(entry.getKey(), this.apply(entry.getValue()));
            }
            return converted;
        }
        return result;
    }
}

