/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.commandhandler;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.grid.session.ActiveSession;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.NewSessionPayload;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.ActiveSessions;
import org.openqa.selenium.remote.server.NewSessionPipeline;
import org.openqa.selenium.remote.server.log.LoggingManager;

public class BeginSession
implements HttpHandler {
    private final NewSessionPipeline pipeline;
    private final ActiveSessions allSessions;
    private final Json json;

    public BeginSession(NewSessionPipeline pipeline, ActiveSessions allSessions, Json json) {
        this.pipeline = pipeline;
        this.allSessions = allSessions;
        this.json = json;
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        ImmutableMap toConvert;
        ActiveSession session;
        try (Reader reader = Contents.reader((HttpMessage)req);
             NewSessionPayload payload = NewSessionPayload.create((Reader)reader);){
            session = this.pipeline.createNewSession(payload);
            this.allSessions.put(session);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        LoggingPreferences loggingPrefs = new LoggingPreferences();
        loggingPrefs.enable("server", Level.INFO);
        Object raw = session.getCapabilities().get("loggingPrefs");
        if (raw instanceof LoggingPreferences) {
            loggingPrefs.addPreferences((LoggingPreferences)raw);
        }
        LoggingManager.perSessionLogHandler().configureLogging(loggingPrefs);
        LoggingManager.perSessionLogHandler().attachToCurrentThread(session.getId());
        ImmutableMap caps = session.getCapabilities().containsKey("webdriver.remote.sessionid") ? session.getCapabilities() : ImmutableMap.builder().putAll(session.getCapabilities()).put((Object)"webdriver.remote.sessionid", (Object)session.getId().toString()).build();
        switch (session.getDownstreamDialect()) {
            case OSS: {
                toConvert = ImmutableMap.of((Object)"status", (Object)0, (Object)"sessionId", (Object)session.getId().toString(), (Object)"value", (Object)caps);
                break;
            }
            case W3C: {
                toConvert = ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"sessionId", (Object)session.getId().toString(), (Object)"capabilities", (Object)caps));
                break;
            }
            default: {
                throw new SessionNotCreatedException("Unrecognized downstream dialect: " + session.getDownstreamDialect());
            }
        }
        byte[] payload = this.json.toJson((Object)toConvert).getBytes(StandardCharsets.UTF_8);
        return (HttpResponse)((HttpResponse)((HttpResponse)((HttpResponse)new HttpResponse().setStatus(200).setHeader("Cache-Control", "no-cache")).setHeader("Content-Type", MediaType.JSON_UTF_8.toString())).setHeader("Content-Length", String.valueOf(payload.length))).setContent(Contents.bytes((byte[])payload));
    }
}

