/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import java.net.URL;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.server.htmlrunner.CoreTestCase;
import org.openqa.selenium.server.htmlrunner.Results;

public class CoreTestSuite {
    private String url;

    public CoreTestSuite(String url) {
        this.url = url;
    }

    public Results run(WebDriver driver, Selenium selenium, URL baseUrl) {
        List allTables;
        if (!this.url.equals(driver.getCurrentUrl())) {
            driver.get(this.url);
        }
        if ((allTables = driver.findElements(By.id((String)"suiteTable"))).isEmpty()) {
            throw new SeleniumException("Unable to locate suite table: " + this.url);
        }
        List allTestUrls = (List)((JavascriptExecutor)driver).executeScript("var toReturn = [];\nfor (var i = 0; i < arguments[0].rows.length; i++) {\n  if (arguments[0].rows[i].cells.length == 0) {\n    continue;\n  }\n  var cell = arguments[0].rows[i].cells[0];\n  if (!cell) { continue; }\n  var allLinks = cell.getElementsByTagName('a');\n  if (allLinks.length > 0) {\n    toReturn.push(allLinks[0].href);\n    arguments[0].rows[i].className += 'insert-test-result';\n  }\n}\nreturn toReturn;\n", new Object[]{allTables.get(0)});
        String rawSuite = (String)((JavascriptExecutor)driver).executeScript("return arguments[0].outerHTML;", new Object[]{allTables.get(0)});
        Results results = new Results(rawSuite);
        for (String testUrl : allTestUrls) {
            new CoreTestCase(testUrl).run(results, driver, selenium, baseUrl);
        }
        return results;
    }
}

