/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.webdriven;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.webdriven.WebDriverCommandProcessor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.grid.session.ActiveSession;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.opera.OperaOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.NewSessionPayload;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.ActiveSessionFactory;
import org.openqa.selenium.remote.server.ActiveSessionListener;
import org.openqa.selenium.remote.server.ActiveSessions;
import org.openqa.selenium.remote.server.NewSessionPipeline;
import org.openqa.selenium.remote.server.WebDriverServlet;
import org.openqa.selenium.safari.SafariOptions;

public class WebDriverBackedSeleniumServlet
extends HttpServlet {
    private static final Map<SessionId, CommandProcessor> PROCESSORS = new ConcurrentHashMap<SessionId, CommandProcessor>();
    private NewSessionPipeline pipeline;
    private ActiveSessions sessions;
    private ActiveSessionListener listener;

    public void init() throws ServletException {
        super.init();
        Object attribute = this.getServletContext().getAttribute(WebDriverServlet.ACTIVE_SESSIONS_KEY);
        if (attribute == null) {
            attribute = new ActiveSessions(5L, TimeUnit.MINUTES);
        }
        this.sessions = (ActiveSessions)attribute;
        this.listener = new ActiveSessionListener(){

            @Override
            public void onStop(ActiveSession session) {
                PROCESSORS.remove(session.getId());
            }
        };
        this.sessions.addListener(this.listener);
        this.pipeline = NewSessionPipeline.builder().add(new ActiveSessionFactory()).create();
    }

    public void destroy() {
        if (this.listener != null) {
            this.sessions.removeListener(this.listener);
        }
        super.destroy();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String cmd = req.getParameter("cmd");
        SessionId sessionId = null;
        if (req.getParameter("sessionId") != null) {
            sessionId = new SessionId(req.getParameter("sessionId"));
        }
        Object[] args = this.deserializeArgs(req);
        if (cmd == null) {
            resp.sendError(404);
            return;
        }
        StringBuilder printableArgs = new StringBuilder("[");
        Joiner.on((String)", ").appendTo(printableArgs, args);
        printableArgs.append("]");
        this.log(String.format("Command request: %s%s on session %s", cmd, printableArgs, sessionId));
        if ("getNewBrowserSession".equals(cmd)) {
            this.startNewSession(resp, (String)args[0], (String)args[1], (String)(args.length == 4 ? args[3] : ""));
            return;
        }
        if ("testComplete".equals(cmd)) {
            CommandProcessor commandProcessor = PROCESSORS.get(sessionId);
            this.sessions.invalidate(sessionId);
            if (commandProcessor == null) {
                resp.sendError(404);
                return;
            }
            this.sendResponse(resp, null);
            return;
        }
        CommandProcessor commandProcessor = PROCESSORS.get(sessionId);
        if (commandProcessor == null) {
            resp.sendError(404);
            return;
        }
        try {
            String result = commandProcessor.doCommand(cmd, (String[])args);
            this.sendResponse(resp, result);
        }
        catch (SeleniumException e) {
            this.sendError(resp, e.getMessage());
        }
    }

    private void startNewSession(HttpServletResponse resp, String browserString, String baseUrl, String options) throws IOException {
        ActiveSession session;
        SessionId sessionId = null;
        if (options.startsWith("webdriver.remote.sessionid")) {
            List split = Splitter.on((String)"=").omitEmptyStrings().trimResults().limit(2).splitToList((CharSequence)options);
            if (!"webdriver.remote.sessionid".equals(split.get(0))) {
                this.log("Unable to find existing webdriver session. Wrong parameter name: " + options);
                this.sendError(resp, "Unable to find existing webdriver session. Wrong parameter name: " + options);
                return;
            }
            if (split.size() != 2) {
                this.log("Attempted to find webdriver id, but none specified. Bailing");
                this.sendError(resp, "Unable to find existing webdriver session. No ID specified");
                return;
            }
            sessionId = new SessionId((String)split.get(1));
        }
        if (sessionId == null) {
            DesiredCapabilities caps;
            switch (browserString) {
                case "*webdriver": {
                    caps = new DesiredCapabilities();
                    break;
                }
                case "*chrome": 
                case "*firefox": 
                case "*firefoxproxy": 
                case "*firefoxchrome": 
                case "*pifirefox": {
                    caps = new FirefoxOptions();
                    break;
                }
                case "*iehta": 
                case "*iexplore": 
                case "*iexploreproxy": 
                case "*piiexplore": {
                    caps = new InternetExplorerOptions();
                    break;
                }
                case "*googlechrome": {
                    caps = new ChromeOptions();
                    break;
                }
                case "*MicrosoftEdge": {
                    caps = new EdgeOptions();
                    break;
                }
                case "*opera": 
                case "*operablink": {
                    caps = new OperaOptions();
                    break;
                }
                case "*safari": 
                case "*safariproxy": {
                    caps = new SafariOptions();
                    break;
                }
                default: {
                    this.sendError(resp, "Unable to match browser string: " + browserString);
                    return;
                }
            }
            try (NewSessionPayload payload = NewSessionPayload.create((Capabilities)caps);){
                ActiveSession session2 = this.pipeline.createNewSession(payload);
                this.sessions.put(session2);
                sessionId = session2.getId();
            }
            catch (Exception e) {
                this.log("Unable to start session", e);
                this.sendError(resp, "Unable to start session. Cause can be found in logs. Message is: " + e.getMessage());
                return;
            }
        }
        if ((session = this.sessions.get(sessionId)) == null) {
            this.log("Attempt to use non-existent session: " + sessionId);
            this.sendError(resp, "Attempt to use non-existent session: " + sessionId);
            return;
        }
        PROCESSORS.put(sessionId, new WebDriverCommandProcessor(baseUrl, session.getWrappedDriver()));
        this.sendResponse(resp, sessionId.toString());
    }

    private void sendResponse(HttpServletResponse resp, String result) throws IOException {
        resp.setStatus(200);
        resp.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
        resp.getWriter().append("OK").append(result == null ? "" : "," + result);
        resp.flushBuffer();
    }

    private void sendError(HttpServletResponse resp, String result) throws IOException {
        resp.setStatus(200);
        resp.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
        resp.getWriter().append("ERROR").append(result == null ? "" : ": " + result);
        resp.flushBuffer();
    }

    private String[] deserializeArgs(HttpServletRequest req) {
        String value;
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 0; i < 5 && (value = req.getParameter(String.valueOf(i + 1))) != null; ++i) {
            args.add(value);
        }
        return args.toArray(new String[args.size()]);
    }
}

