/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import com.google.common.collect.ImmutableMap;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.json.JsonInput;

public class CreateSessionResponse {
    private final Session session;
    private final byte[] downstreamEncodedResponse;

    public CreateSessionResponse(Session session, byte[] downstreamEncodedResponse) {
        this.session = Objects.requireNonNull(session);
        this.downstreamEncodedResponse = Objects.requireNonNull(downstreamEncodedResponse);
    }

    public Session getSession() {
        return this.session;
    }

    public byte[] getDownstreamEncodedResponse() {
        return this.downstreamEncodedResponse;
    }

    private Map<String, Object> toJson() {
        return ImmutableMap.of((Object)"downstreamEncodedResponse", (Object)Base64.getEncoder().encodeToString(this.downstreamEncodedResponse), (Object)"session", (Object)this.session);
    }

    private static CreateSessionResponse fromJson(JsonInput input) {
        Session session = null;
        byte[] downstreamResponse = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "downstreamEncodedResponse": {
                    downstreamResponse = Base64.getDecoder().decode(input.nextString());
                    continue block8;
                }
                case "session": {
                    session = (Session)input.read(Session.class);
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CreateSessionResponse(session, downstreamResponse);
    }
}

