/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.thoughtworks.selenium.webdriven.WebDriverBackedSelenium;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.server.htmlrunner.CoreTestSuite;
import org.openqa.selenium.server.htmlrunner.HTMLTestResults;
import org.openqa.selenium.server.htmlrunner.Results;
import org.seleniumhq.jetty9.server.ConnectionFactory;
import org.seleniumhq.jetty9.server.Connector;
import org.seleniumhq.jetty9.server.Handler;
import org.seleniumhq.jetty9.server.HttpConfiguration;
import org.seleniumhq.jetty9.server.HttpConnectionFactory;
import org.seleniumhq.jetty9.server.Server;
import org.seleniumhq.jetty9.server.ServerConnector;
import org.seleniumhq.jetty9.server.handler.ContextHandler;
import org.seleniumhq.jetty9.server.handler.ResourceHandler;
import org.seleniumhq.jetty9.util.resource.PathResource;
import org.seleniumhq.jetty9.util.resource.Resource;

public class HTMLLauncher {
    private static Logger log = Logger.getLogger(HTMLLauncher.class.getName());
    private Server server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runHTMLSuite(String browser, String startURL, String suiteURL, File outputFile, long timeoutInSeconds, String userExtensions) throws IOException {
        File parent = outputFile.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        if (outputFile.exists() && !outputFile.canWrite()) {
            throw new IOException("Can't write to outputFile: " + outputFile.getAbsolutePath());
        }
        long timeoutInMs = 1000L * timeoutInSeconds;
        if (timeoutInMs < 0L) {
            log.warning("Looks like the timeout overflowed, so resetting it to the maximum.");
            timeoutInMs = Long.MAX_VALUE;
        }
        WebDriver driver = null;
        try {
            List allTables;
            driver = this.createDriver(browser);
            URL suiteUrl = this.determineSuiteUrl(startURL, suiteURL);
            driver.get(suiteUrl.toString());
            WebDriverBackedSelenium selenium = new WebDriverBackedSelenium(driver, startURL);
            selenium.setTimeout(String.valueOf(timeoutInMs));
            if (userExtensions != null) {
                selenium.setExtensionJs(userExtensions);
            }
            if ((allTables = driver.findElements(By.id((String)"suiteTable"))).isEmpty()) {
                throw new RuntimeException("Unable to find suite table: " + driver.getPageSource());
            }
            Results results = new CoreTestSuite(suiteUrl.toString()).run(driver, selenium, new URL(startURL));
            HTMLTestResults htmlResults = results.toSuiteResult();
            try (BufferedWriter writer = Files.newBufferedWriter(outputFile.toPath(), new OpenOption[0]);){
                htmlResults.write(writer);
            }
            String string = results.isSuccessful() ? "PASSED" : "FAILED";
            return string;
        }
        finally {
            if (this.server != null) {
                try {
                    this.server.stop();
                }
                catch (Exception e) {
                    log.log(Level.INFO, "Exception shutting down server. You may ignore this.", e);
                }
            }
            if (driver != null) {
                driver.quit();
            }
        }
    }

    private URL determineSuiteUrl(String startURL, String suiteURL) throws IOException {
        if (suiteURL.startsWith("https://") || suiteURL.startsWith("http://")) {
            return this.verifySuiteUrl(new URL(suiteURL));
        }
        Path path = Paths.get(suiteURL, new String[0]).toAbsolutePath();
        if (Files.exists(path, new LinkOption[0])) {
            this.server = new Server();
            HttpConfiguration httpConfig = new HttpConfiguration();
            ServerConnector http = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            int port = PortProber.findFreePort();
            http.setPort(port);
            http.setIdleTimeout(500000L);
            this.server.setConnectors(new Connector[]{http});
            ResourceHandler handler = new ResourceHandler();
            handler.setDirectoriesListed(true);
            handler.setWelcomeFiles(new String[]{path.getFileName().toString(), "index.html"});
            handler.setBaseResource((Resource)new PathResource(path.toFile().getParentFile().toPath().toRealPath(new LinkOption[0])));
            ContextHandler context = new ContextHandler("/tests");
            context.setHandler((Handler)handler);
            this.server.setHandler((Handler)context);
            try {
                this.server.start();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            PortProber.waitForPortUp((int)port, (int)15, (TimeUnit)TimeUnit.SECONDS);
            URL serverUrl = this.server.getURI().toURL();
            return new URL(serverUrl.getProtocol(), serverUrl.getHost(), serverUrl.getPort(), "/tests/");
        }
        URL browser = new URL(startURL);
        return this.verifySuiteUrl(new URL(browser, suiteURL));
    }

    private URL verifySuiteUrl(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            throw new IOException("The HTMLLauncher only supports relative HTTP URLs");
        }
        HttpURLConnection httpConnection = (HttpURLConnection)connection;
        httpConnection.setInstanceFollowRedirects(true);
        httpConnection.setRequestMethod("HEAD");
        int responseCode = httpConnection.getResponseCode();
        if (responseCode != 200) {
            throw new IOException("Invalid suite URL: " + url);
        }
        return url;
    }

    public static int mainInt(String ... args) throws Exception {
        Args processed = new Args();
        JCommander jCommander = new JCommander((Object)processed);
        jCommander.setCaseSensitiveOptions(false);
        jCommander.parse(args);
        if (processed.help) {
            StringBuilder help = new StringBuilder();
            jCommander.usage(help);
            System.err.print(help);
            return 0;
        }
        if (!HTMLLauncher.validateArgs(processed)) {
            return -1;
        }
        Path resultsPath = Paths.get((String)processed.htmlSuite.get(3), new String[0]);
        Files.createDirectories(resultsPath, new FileAttribute[0]);
        String suite = (String)processed.htmlSuite.get(2);
        String startURL = (String)processed.htmlSuite.get(1);
        String[] browsers = new String[]{(String)processed.htmlSuite.get(0)};
        HTMLLauncher launcher = new HTMLLauncher();
        boolean passed = true;
        for (String browser : browsers) {
            String reportFileName = browser.contains(" ") ? browser.substring(0, browser.indexOf(32)) : browser;
            File results = resultsPath.resolve(reportFileName.substring(1) + ".results.html").toFile();
            String result = "FAILED";
            try {
                long timeout;
                try {
                    timeout = Long.parseLong(processed.timeout);
                }
                catch (NumberFormatException e) {
                    System.err.println("Timeout does not appear to be a number: " + processed.timeout);
                    return -2;
                }
                result = launcher.runHTMLSuite(browser, startURL, suite, results, timeout, processed.userExtensions);
                passed &= "PASSED".equals(result);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, "Test of browser failed: " + browser, e);
                passed = false;
            }
        }
        return passed ? 1 : 0;
    }

    private static boolean validateArgs(Args processed) {
        if (processed.multiWindow) {
            System.err.println("Multi-window mode is longer used as an option and will be ignored.");
        }
        if (processed.port != 0) {
            System.err.println("Port is longer used as an option and will be ignored.");
        }
        if (processed.trustAllSSLCertificates) {
            System.err.println("Trusting all ssl certificates is no longer a user-settable option.");
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        System.exit(HTMLLauncher.mainInt(args));
    }

    private WebDriver createDriver(String browser) {
        String[] parts = browser.split(" ", 2);
        switch (browser = parts[0]) {
            case "*chrome": 
            case "*firefox": 
            case "*firefoxproxy": 
            case "*firefoxchrome": 
            case "*pifirefox": {
                FirefoxOptions options = new FirefoxOptions().setLegacy(false);
                if (parts.length > 1) {
                    options.setBinary(parts[1]);
                }
                return new FirefoxDriver(options);
            }
            case "*iehta": 
            case "*iexplore": 
            case "*iexploreproxy": 
            case "*piiexplore": {
                return new InternetExplorerDriver();
            }
            case "*googlechrome": {
                return new ChromeDriver();
            }
            case "*MicrosoftEdge": {
                return new EdgeDriver();
            }
            case "*opera": 
            case "*operablink": {
                return new OperaDriver();
            }
            case "*safari": 
            case "*safariproxy": {
                return new SafariDriver();
            }
        }
        throw new RuntimeException("Unrecognized browser: " + browser);
    }

    public static class Args {
        @Parameter(names={"-htmlSuite"}, required=true, arity=4, description="Run an HTML Suite: \"*browser\" \"http://baseUrl.com\" \"path\\to\\HTMLSuite.html\" \"path\\to\\report\\dir\"")
        private List<String> htmlSuite;
        @Parameter(names={"-timeout"}, description="Timeout to use in seconds")
        private String timeout = "30";
        @Parameter(names={"-userExtensions"}, description="User extensions to attempt to use.")
        private String userExtensions;
        @Parameter(names={"-multiwindow"}, hidden=true)
        private boolean multiWindow = true;
        @Parameter(names={"-port"}, hidden=true)
        private Integer port = 0;
        @Parameter(names={"-trustAllSSLCertificates"}, hidden=true)
        private boolean trustAllSSLCertificates;
        @Parameter(names={"-help", "--help", "-h"}, description="This help message", help=true)
        private boolean help;
    }
}

