/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.server.ActiveSession;
import org.openqa.selenium.remote.server.DefaultDriverProvider;
import org.openqa.selenium.remote.server.DriverProvider;
import org.openqa.selenium.remote.server.InMemorySession;
import org.openqa.selenium.remote.server.NewSessionPayload;
import org.openqa.selenium.remote.server.ServicedSession;
import org.openqa.selenium.remote.server.SessionFactory;

public class ActiveSessionFactory {
    private static final Logger LOG = Logger.getLogger(ActiveSessionFactory.class.getName());
    private static final Function<String, Class<?>> CLASS_EXISTS = name -> {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    };
    private volatile Map<Predicate<Capabilities>, SessionFactory> factories;

    public ActiveSessionFactory() {
        LinkedHashMap<Predicate<Capabilities>, SessionFactory> builder = new LinkedHashMap<Predicate<Capabilities>, SessionFactory>();
        StreamSupport.stream(this.loadDriverProviders().spliterator(), false).forEach(p -> {
            SessionFactory cfr_ignored_0 = builder.put(p::canCreateDriverInstanceFor, new InMemorySession.Factory((DriverProvider)p));
        });
        this.bind(builder, "org.openqa.selenium.firefox.FirefoxDriver", caps -> {
            Object marionette = caps.getCapability("marionette");
            return marionette instanceof Boolean && (Boolean)marionette == false;
        }, (Capabilities)DesiredCapabilities.firefox());
        ImmutableMap.builder().put(ActiveSessionFactory.browserName((Capabilities)DesiredCapabilities.chrome()), (Object)"org.openqa.selenium.chrome.ChromeDriverService").put(ActiveSessionFactory.containsKey("chromeOptions"), (Object)"org.openqa.selenium.chrome.ChromeDriverService").put(ActiveSessionFactory.browserName((Capabilities)DesiredCapabilities.edge()), (Object)"org.openqa.selenium.edge.EdgeDriverService").put(ActiveSessionFactory.containsKey("edgeOptions"), (Object)"org.openqa.selenium.edge.EdgeDriverService").put(ActiveSessionFactory.browserName((Capabilities)DesiredCapabilities.firefox()), (Object)"org.openqa.selenium.firefox.GeckoDriverService").put(ActiveSessionFactory.containsKey(Pattern.compile("^moz:.*")), (Object)"org.openqa.selenium.firefox.GeckoDriverService").put(ActiveSessionFactory.browserName((Capabilities)DesiredCapabilities.internetExplorer()), (Object)"org.openqa.selenium.ie.InternetExplorerDriverService").put(ActiveSessionFactory.containsKey("se:ieOptions"), (Object)"org.openqa.selenium.ie.InternetExplorerDriverService").put(ActiveSessionFactory.browserName((Capabilities)DesiredCapabilities.opera()), (Object)"org.openqa.selenium.opera.OperaDriverService").put(ActiveSessionFactory.browserName((Capabilities)DesiredCapabilities.operaBlink()), (Object)"org.openqa.selenium.ie.OperaDriverService").put(ActiveSessionFactory.browserName((Capabilities)DesiredCapabilities.phantomjs()), (Object)"org.openqa.selenium.phantomjs.PhantomJSDriverService").put(ActiveSessionFactory.browserName((Capabilities)DesiredCapabilities.safari()), (Object)"org.openqa.selenium.safari.SafariDriverService").put(ActiveSessionFactory.containsKey(Pattern.compile("^safari\\..*")), (Object)"org.openqa.selenium.safari.SafariDriverService").build().entrySet().stream().filter(e -> CLASS_EXISTS.apply((String)e.getValue()) != null).forEach(e -> {
            SessionFactory cfr_ignored_0 = builder.put((Predicate<Capabilities>)e.getKey(), new ServicedSession.Factory((String)e.getValue()));
        });
        this.bind(builder, "org.openqa.selenium.htmlunit.HtmlUnitDriver", ActiveSessionFactory.browserName((Capabilities)DesiredCapabilities.htmlUnit()), (Capabilities)DesiredCapabilities.htmlUnit());
        Stream.of("org.openqa.selenium.chrome.ChromeDriverService", "org.openqa.selenium.firefox.GeckoDriverService", "org.openqa.selenium.edge.EdgeDriverService", "org.openqa.selenium.ie.InternetExplorerDriverService", "org.openqa.selenium.safari.SafariDriverService").filter(name -> CLASS_EXISTS.apply((String)name) != null).findFirst().ifPresent(serviceName -> {
            LOG.info("Binding default provider to: " + serviceName);
            builder.put(ignored -> true, new ServicedSession.Factory((String)serviceName));
        });
        this.factories = ImmutableMap.copyOf(builder);
    }

    public synchronized ActiveSessionFactory bind(Predicate<Capabilities> onThis, SessionFactory useThis) {
        Objects.requireNonNull(onThis, "Predicated needed.");
        Objects.requireNonNull(useThis, "SessionFactory is required");
        LOG.info(String.format("Binding %s to respond to %s", useThis, onThis));
        LinkedHashMap<Predicate<Capabilities>, SessionFactory> newMap = new LinkedHashMap<Predicate<Capabilities>, SessionFactory>();
        newMap.put(onThis, useThis);
        newMap.putAll(this.factories);
        this.factories = newMap;
        return this;
    }

    @VisibleForTesting
    protected Iterable<DriverProvider> loadDriverProviders() {
        return () -> ServiceLoader.load(DriverProvider.class).iterator();
    }

    private void bind(Map<Predicate<Capabilities>, SessionFactory> builder, String className, Predicate<Capabilities> predicate, Capabilities capabilities) {
        try {
            Class<?> clazz = CLASS_EXISTS.apply(className);
            if (clazz == null) {
                return;
            }
            Class<WebDriver> driverClass = clazz.asSubclass(WebDriver.class);
            builder.put(predicate, new InMemorySession.Factory(new DefaultDriverProvider(capabilities, driverClass)));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private static Predicate<Capabilities> browserName(Capabilities caps) {
        return toCompare -> caps.getBrowserName().equals(toCompare.getBrowserName());
    }

    private static Predicate<Capabilities> containsKey(String keyName) {
        Objects.requireNonNull(keyName, "Key name must be set");
        return toCompare -> toCompare.getCapability(keyName) != null;
    }

    private static Predicate<Capabilities> containsKey(Pattern pattern) {
        return toCompare -> toCompare.asMap().keySet().stream().anyMatch(pattern.asPredicate());
    }

    public ActiveSession createSession(NewSessionPayload newSessionPayload) throws IOException {
        return newSessionPayload.stream().peek(caps -> LOG.info("Capabilities are: " + caps)).flatMap(caps -> this.factories.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(caps)).peek(e -> LOG.info(String.format("%s matched %s", caps, e.getValue()))).map(Map.Entry::getValue)).findFirst().map(factory -> factory.apply(newSessionPayload)).orElseThrow(() -> new SessionNotCreatedException("Unable to create a new session because of no configuration."));
    }
}

