/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.thoughtworks.selenium.SeleneseTestBase;
import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.Wait;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.server.htmlrunner.CoreRunnerError;
import org.openqa.selenium.server.htmlrunner.CoreStepFactory;
import org.openqa.selenium.server.htmlrunner.NextStepDecorator;

class ReflectivelyDiscoveredSteps
implements Supplier<ImmutableMap<String, CoreStepFactory>> {
    private static final Logger LOG = Logger.getLogger("Selenium Core Step");
    private static Supplier<ImmutableMap<String, CoreStepFactory>> REFLECTIVE_STEPS = Suppliers.memoize(ReflectivelyDiscoveredSteps::discover);

    ReflectivelyDiscoveredSteps() {
    }

    public ImmutableMap<String, CoreStepFactory> get() {
        return (ImmutableMap)REFLECTIVE_STEPS.get();
    }

    private static ImmutableMap<String, CoreStepFactory> discover() {
        ImmutableMap.Builder factories = ImmutableMap.builder();
        HashSet<String> seenNames = new HashSet<String>();
        seenNames.add("addCustomRequestHeader");
        seenNames.add("allowNativeXpath");
        seenNames.add("pause");
        seenNames.add("rollup");
        seenNames.add("setBrowserLogLevel");
        seenNames.add("setExtensionJs");
        seenNames.add("start");
        seenNames.add("stop");
        for (final Method method : Selenium.class.getMethods()) {
            boolean isAccessor;
            String shortName;
            if (!seenNames.add(method.getName()) || method.getParameterCount() > 2) continue;
            CoreStepFactory factory = (locator, value) -> (selenium, state) -> ReflectivelyDiscoveredSteps.invokeMethod(method, selenium, locator, value, result -> NextStepDecorator.IDENTITY);
            factories.put((Object)method.getName(), (Object)factory);
            if (method.getName().startsWith("get")) {
                shortName = method.getName().substring("get".length());
                isAccessor = true;
            } else if (method.getName().startsWith("is")) {
                shortName = method.getName().substring("is".length());
                isAccessor = true;
            } else {
                shortName = null;
                isAccessor = false;
            }
            if (shortName != null) {
                String negatedName = ReflectivelyDiscoveredSteps.negateName(shortName);
                factories.put((Object)("assert" + shortName), (loc, val) -> (selenium, state) -> ReflectivelyDiscoveredSteps.invokeMethod(method, selenium, state.expand(loc), state.expand(val), seen -> {
                    Object expected = ReflectivelyDiscoveredSteps.getExpectedValue(method, state.expand(loc), state.expand(val));
                    try {
                        SeleneseTestBase.assertEquals(expected, seen);
                    }
                    catch (AssertionError e) {
                        return NextStepDecorator.ASSERTION_FAILED(((Throwable)((Object)e)).getMessage());
                    }
                    return NextStepDecorator.IDENTITY;
                }));
                factories.put((Object)("assert" + negatedName), (loc, val) -> (selenium, state) -> ReflectivelyDiscoveredSteps.invokeMethod(method, selenium, state.expand(loc), state.expand(val), seen -> {
                    Object expected = ReflectivelyDiscoveredSteps.getExpectedValue(method, state.expand(loc), state.expand(val));
                    try {
                        SeleneseTestBase.assertNotEquals(expected, seen);
                        return NextStepDecorator.IDENTITY;
                    }
                    catch (AssertionError e) {
                        return NextStepDecorator.ASSERTION_FAILED(((Throwable)((Object)e)).getMessage());
                    }
                }));
                factories.put((Object)("verify" + shortName), (loc, val) -> (selenium, state) -> ReflectivelyDiscoveredSteps.invokeMethod(method, selenium, state.expand(loc), state.expand(val), seen -> {
                    Object expected = ReflectivelyDiscoveredSteps.getExpectedValue(method, state.expand(loc), state.expand(val));
                    try {
                        SeleneseTestBase.assertEquals(expected, seen);
                        return NextStepDecorator.IDENTITY;
                    }
                    catch (AssertionError e) {
                        return NextStepDecorator.VERIFICATION_FAILED(((Throwable)((Object)e)).getMessage());
                    }
                }));
                factories.put((Object)("verify" + negatedName), (loc, val) -> (selenium, state) -> ReflectivelyDiscoveredSteps.invokeMethod(method, selenium, state.expand(loc), state.expand(val), seen -> {
                    Object expected = ReflectivelyDiscoveredSteps.getExpectedValue(method, state.expand(loc), state.expand(val));
                    try {
                        SeleneseTestBase.assertNotEquals(expected, seen);
                        return NextStepDecorator.IDENTITY;
                    }
                    catch (AssertionError e) {
                        return NextStepDecorator.VERIFICATION_FAILED(((Throwable)((Object)e)).getMessage());
                    }
                }));
            }
            if (isAccessor) {
                factories.put((Object)("store" + shortName), (loc, val) -> (selenium, state) -> ReflectivelyDiscoveredSteps.invokeMethod(method, selenium, state.expand(loc), state.expand(val), toStore -> {
                    state.store(state.expand(loc), toStore);
                    return NextStepDecorator.IDENTITY;
                }));
                factories.put((Object)("waitFor" + shortName), (loc, val) -> (selenium, state) -> {
                    final String[] args = ReflectivelyDiscoveredSteps.buildArgs(method, state.expand(loc), state.expand(val));
                    try {
                        new Wait(){

                            @Override
                            public boolean until() {
                                try {
                                    Object result = method.invoke((Object)selenium, (Object[])args);
                                    if (Boolean.class.isAssignableFrom(result.getClass())) {
                                        return (Boolean)result;
                                    }
                                    return true;
                                }
                                catch (IllegalAccessException e) {
                                    throw new RuntimeException(e);
                                }
                                catch (InvocationTargetException e) {
                                    return false;
                                }
                            }
                        }.wait("Can't wait for " + shortName);
                    }
                    catch (Wait.WaitTimedOutException e) {
                        return NextStepDecorator.ERROR(e);
                    }
                    return NextStepDecorator.IDENTITY;
                });
                factories.put((Object)("waitFor" + ReflectivelyDiscoveredSteps.negateName(shortName)), (loc, val) -> (selenium, state) -> {
                    final String[] args = ReflectivelyDiscoveredSteps.buildArgs(method, state.expand(loc), state.expand(val));
                    try {
                        new Wait(){

                            @Override
                            public boolean until() {
                                try {
                                    Object result = method.invoke((Object)selenium, (Object[])args);
                                    if (Boolean.class.isAssignableFrom(result.getClass())) {
                                        return (Boolean)result == false;
                                    }
                                    return false;
                                }
                                catch (IllegalAccessException e) {
                                    throw new RuntimeException(e);
                                }
                                catch (InvocationTargetException e) {
                                    return true;
                                }
                            }
                        }.wait("Managed to wait for " + shortName);
                    }
                    catch (Wait.WaitTimedOutException e) {
                        return NextStepDecorator.ERROR(e);
                    }
                    return NextStepDecorator.IDENTITY;
                });
            }
            factories.put((Object)(method.getName() + "AndWait"), (loc, val) -> (selenium, state) -> ReflectivelyDiscoveredSteps.invokeMethod(method, selenium, state.expand(loc), state.expand(val), seen -> {
                selenium.waitForPageToLoad("30000");
                return NextStepDecorator.IDENTITY;
            }));
        }
        return factories.build();
    }

    private static String negateName(String shortName) {
        Pattern pattern = Pattern.compile("^(.*)Present$");
        Matcher matcher = pattern.matcher(shortName);
        if (matcher.matches()) {
            return matcher.group(1) + "NotPresent";
        }
        return "Not" + shortName;
    }

    private static String[] buildArgs(Method method, String locator, String value) {
        String[] args = new String[method.getParameterCount()];
        switch (method.getParameterCount()) {
            case 2: {
                args[1] = value.trim();
            }
            case 1: {
                args[0] = locator.trim();
                break;
            }
        }
        return args;
    }

    private static Object getExpectedValue(Method method, String locator, String value) {
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(Boolean.TYPE) || returnType.equals(Boolean.class)) {
            return true;
        }
        switch (method.getParameterCount()) {
            case 0: {
                return locator;
            }
            case 1: {
                return value;
            }
        }
        throw new SeleniumException("Unable to find expected result: " + method.getName());
    }

    private static NextStepDecorator invokeMethod(Method method, Selenium selenium, String locator, String value, OnSuccess onSuccess) {
        Object[] args = ReflectivelyDiscoveredSteps.buildArgs(method, locator, value);
        try {
            Object result = method.invoke((Object)selenium, args);
            return onSuccess.handle(result);
        }
        catch (ReflectiveOperationException e) {
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                if (cause instanceof SeleniumException) {
                    return NextStepDecorator.ERROR(cause);
                }
                if (!(cause instanceof Wait.WaitTimedOutException)) continue;
                return NextStepDecorator.ERROR(cause);
            }
            throw new CoreRunnerError(String.format("Unable to emulate %s %s", method.getName(), Arrays.asList(args)), new Object[]{e});
        }
    }

    private static interface OnSuccess {
        public NextStepDecorator handle(Object var1);
    }
}

