/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class TestState {
    private static Map<String, Object> storedValues = new HashMap<String, Object>();
    private long commandTimeOut = TimeUnit.SECONDS.toMillis(30L);
    private long speed = 0L;

    TestState() {
    }

    public void sleepTight() {
        try {
            Thread.sleep(this.speed);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unlikely: " + Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    public void store(String key, Object value) {
        storedValues.put(key, value);
    }

    private String getValue(String key) {
        return (String)Preconditions.checkNotNull((Object)key);
    }

    public String expand(String toExpand) {
        Pattern toMatch = Pattern.compile("\\$\\{(\\w+)\\}", 8);
        Matcher matcher = toMatch.matcher(toExpand);
        StringBuilder toReturn = new StringBuilder();
        int lastEnd = 0;
        while (matcher.find()) {
            toReturn.append(toExpand.substring(lastEnd, matcher.start()));
            toReturn.append(this.getValue(matcher.group(1)));
            lastEnd = matcher.end();
        }
        toReturn.append(toExpand.substring(lastEnd));
        return toReturn.toString();
    }
}

