/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.data.SlotMatcher;

public class DefaultSlotMatcher
implements SlotMatcher,
Serializable {
    private static final List<String> EXTENSION_CAPABILITIES_PREFIXES = Arrays.asList("goog:", "moz:", "ms:", "se:");

    @Override
    public boolean matches(Capabilities stereotype, Capabilities capabilities) {
        if (capabilities.asMap().isEmpty()) {
            return false;
        }
        if (!this.initialMatch(stereotype, capabilities).booleanValue()) {
            return false;
        }
        if (!this.managedDownloadsEnabled(stereotype, capabilities).booleanValue()) {
            return false;
        }
        if (!this.platformVersionMatch(stereotype, capabilities).booleanValue()) {
            return false;
        }
        if (!this.extensionCapabilitiesMatch(stereotype, capabilities).booleanValue()) {
            return false;
        }
        boolean browserNameMatch = capabilities.getBrowserName() == null || capabilities.getBrowserName().isEmpty() || Objects.equals(stereotype.getBrowserName(), capabilities.getBrowserName());
        boolean browserVersionMatch = capabilities.getBrowserVersion() == null || capabilities.getBrowserVersion().isEmpty() || Objects.equals(stereotype.getBrowserVersion(), capabilities.getBrowserVersion());
        boolean platformNameMatch = capabilities.getPlatformName() == null || Objects.equals(stereotype.getPlatformName(), capabilities.getPlatformName()) || stereotype.getPlatformName() != null && stereotype.getPlatformName().is(capabilities.getPlatformName());
        return browserNameMatch && browserVersionMatch && platformNameMatch;
    }

    private Boolean initialMatch(Capabilities stereotype, Capabilities capabilities) {
        return stereotype.getCapabilityNames().stream().filter(name -> !name.contains(":")).filter(name -> !"platform".equalsIgnoreCase((String)name) && !"platformName".equalsIgnoreCase((String)name)).map(name -> {
            if (capabilities.getCapability(name) instanceof String) {
                return stereotype.getCapability(name).toString().equalsIgnoreCase(capabilities.getCapability(name).toString());
            }
            return capabilities.getCapability(name) == null || Objects.equals(stereotype.getCapability(name), capabilities.getCapability(name));
        }).reduce(Boolean::logicalAnd).orElse(true);
    }

    private Boolean managedDownloadsEnabled(Capabilities stereotype, Capabilities capabilities) {
        Object raw = capabilities.getCapability("se:downloadsEnabled");
        if (raw == null || !Boolean.parseBoolean(raw.toString())) {
            return true;
        }
        raw = stereotype.getCapability("se:downloadsEnabled");
        return raw != null && Boolean.parseBoolean(raw.toString());
    }

    private Boolean platformVersionMatch(Capabilities stereotype, Capabilities capabilities) {
        return capabilities.getCapabilityNames().stream().filter(name -> name.contains("platformVersion")).map(platformVersionCapName -> Objects.equals(stereotype.getCapability(platformVersionCapName), capabilities.getCapability(platformVersionCapName))).reduce(Boolean::logicalAnd).orElse(true);
    }

    private Boolean extensionCapabilitiesMatch(Capabilities stereotype, Capabilities capabilities) {
        return stereotype.getCapabilityNames().stream().filter(name -> name.contains(":")).filter(name -> capabilities.asMap().containsKey(name)).filter(name -> EXTENSION_CAPABILITIES_PREFIXES.stream().noneMatch(name::contains)).map(name -> {
            if (capabilities.getCapability(name) instanceof String) {
                return stereotype.getCapability(name).toString().equalsIgnoreCase(capabilities.getCapability(name).toString());
            }
            return capabilities.getCapability(name) == null || Objects.equals(stereotype.getCapability(name), capabilities.getCapability(name));
        }).reduce(Boolean::logicalAnd).orElse(true);
    }
}

