/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.client;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.docker.client.ApiVersionAdapter;

class V140Adapter
implements ApiVersionAdapter {
    private static final Logger LOG = Logger.getLogger(V140Adapter.class.getName());
    private final String apiVersion;

    public V140Adapter(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Override
    public Map<String, Object> adaptImageResponse(Map<String, Object> response) {
        if (response == null) {
            return response;
        }
        HashMap<String, Object> adapted = new HashMap<String, Object>(response);
        if (adapted.containsKey("VirtualSize") && !adapted.containsKey("Size")) {
            adapted.put("Size", adapted.get("VirtualSize"));
            LOG.fine("Normalized VirtualSize to Size for API version " + this.apiVersion);
        }
        return adapted;
    }

    @Override
    public Map<String, Object> adaptContainerCreateRequest(Map<String, Object> request) {
        Map endpointsConfig;
        if (request == null) {
            return request;
        }
        HashMap<String, Object> adapted = new HashMap<String, Object>(request);
        Map networkingConfig = (Map)adapted.get("NetworkingConfig");
        if (networkingConfig != null && (endpointsConfig = (Map)networkingConfig.get("EndpointsConfig")) != null && endpointsConfig.size() > 1) {
            LOG.warning("API version " + this.apiVersion + " does not support multiple networks. Only the first network will be used. Consider upgrading to API v1.44+");
        }
        return adapted;
    }

    @Override
    public Map<String, Object> adaptContainerInspectResponse(Map<String, Object> response) {
        if (response == null) {
            return response;
        }
        return response;
    }

    @Override
    public boolean supportsMultipleNetworks() {
        return false;
    }

    @Override
    public boolean hasVirtualSizeField() {
        return true;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }
}

