/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.jmx;

import java.lang.management.ManagementFactory;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.grid.jmx.MBean;

@NullMarked
public class JMXHelper {
    private static final Logger LOG = Logger.getLogger(JMXHelper.class.getName());

    public @Nullable MBean register(Object bean) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        MBean mBean = new MBean(bean);
        try {
            mbs.registerMBean(mBean, mBean.getObjectName());
            return mBean;
        }
        catch (InstanceAlreadyExistsException t) {
            return mBean;
        }
        catch (Throwable t) {
            LOG.severe("Error during execution: " + t.getMessage());
            return null;
        }
    }

    public void unregister(ObjectName objectName) {
        if (objectName != null) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                mbs.unregisterMBean(objectName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

