/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;

public class EnsureSpecCompliantResponseHeaders
implements Filter {
    public HttpHandler apply(HttpHandler httpHandler) {
        Require.nonNull((String)"Next handler", (Object)httpHandler);
        return req -> {
            HttpResponse res = httpHandler.execute(req);
            if (res.getHeader("Content-Type") == null) {
                res.addHeader("Content-Type", "application/json; charset=utf-8");
            }
            if (res.getHeader("Cache-Control") == null) {
                res.addHeader("Cache-Control", "no-cache");
            }
            return res;
        };
    }
}

