/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node;

import com.google.common.collect.ImmutableMap;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class ForwardWebDriverCommand
implements HttpHandler {
    private final Node node;

    ForwardWebDriverCommand(Node node) {
        this.node = (Node)Require.nonNull((String)"Node", (Object)node);
    }

    public boolean matches(HttpRequest req) {
        return HttpSessionId.getSessionId((String)req.getUri()).map(id -> this.node.isSessionOwner(new SessionId(id))).orElse(false);
    }

    public HttpResponse execute(HttpRequest req) {
        if (this.matches(req)) {
            return this.node.executeWebDriverCommand(req);
        }
        return (HttpResponse)new HttpResponse().setStatus(500).setContent(Contents.asJson((Object)ImmutableMap.of((Object)"error", (Object)String.format("Session not found in node %s", this.node.getId()))));
    }
}

