/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.security;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.logging.Logger;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;

public class BasicAuthenticationFilter
implements Filter {
    private static final Logger LOG = Logger.getLogger(BasicAuthenticationFilter.class.getName());
    private final String passphrase;

    public BasicAuthenticationFilter(String user, String password) {
        this.passphrase = Base64.getEncoder().encodeToString((user + ":" + password).getBytes(StandardCharsets.UTF_8));
    }

    public HttpHandler apply(HttpHandler next) {
        return req -> {
            Require.nonNull((String)"Request", (Object)req);
            String auth = req.getHeader("Authorization");
            if (!this.isAuthorized(auth)) {
                if (auth != null) {
                    LOG.info("Unauthorized request to " + String.valueOf(req));
                }
                return (HttpResponse)new HttpResponse().setStatus(401).addHeader("WWW-Authenticate", "Basic realm=\"selenium-server\"");
            }
            return next.execute(req);
        };
    }

    private boolean isAuthorized(String auth) {
        int index;
        if (auth != null && (index = auth.indexOf(32) + 1) > 0) {
            return this.passphrase.equals(auth.substring(index));
        }
        return false;
    }
}

