/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.concurrent.GuardedRunnable;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.web.ReverseProxyHandler;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.remote.ErrorCodec;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.AttributeMap;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.TraceContext;
import org.openqa.selenium.remote.tracing.Tracer;

class HandleSession
implements HttpHandler {
    private final Tracer tracer;
    private final HttpClient.Factory httpClientFactory;
    private final SessionMap sessions;
    private final Cache<URL, HttpClient> httpClients;

    HandleSession(Tracer tracer, HttpClient.Factory httpClientFactory, SessionMap sessions) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.httpClientFactory = (HttpClient.Factory)Require.nonNull((String)"HTTP client factory", (Object)httpClientFactory);
        this.sessions = (SessionMap)Require.nonNull((String)"Sessions", (Object)sessions);
        this.httpClients = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(4L)).removalListener(removal -> ((HttpClient)removal.getValue()).close()).build();
        ScheduledExecutorService cleanUpHttpClientsCacheService = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("HandleSession - Clean up http clients cache");
            return thread;
        });
        cleanUpHttpClientsCacheService.scheduleAtFixedRate(GuardedRunnable.guard(() -> this.httpClients.cleanUp()), 1L, 1L, TimeUnit.MINUTES);
    }

    public HttpResponse execute(HttpRequest req) {
        try (Span span = HttpTracing.newSpanAsChildOf((Tracer)this.tracer, (HttpRequest)req, (String)"router.handle_session");){
            AttributeMap attributeMap = this.tracer.createAttributeMap();
            attributeMap.put(AttributeKey.HTTP_HANDLER_CLASS.getKey(), this.getClass().getName());
            Tags.HTTP_REQUEST.accept(span, req);
            Tags.HTTP_REQUEST_EVENT.accept(attributeMap, req);
            SessionId id = HttpSessionId.getSessionId((String)req.getUri()).map(SessionId::new).orElseThrow(() -> {
                NoSuchSessionException exception = new NoSuchSessionException("Cannot find session: " + req);
                Tags.EXCEPTION.accept(attributeMap, exception);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), "Unable to execute request for an existing session: " + exception.getMessage());
                span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                return exception;
            });
            RemoteTags.SESSION_ID.accept(span, id);
            RemoteTags.SESSION_ID_EVENT.accept(attributeMap, id);
            try {
                HttpTracing.inject((Tracer)this.tracer, (TraceContext)span, (HttpRequest)req);
                HttpResponse res = this.loadSessionId(this.tracer, span, id).call().execute(req);
                Tags.HTTP_RESPONSE.accept(span, res);
                HttpResponse httpResponse = res;
                return httpResponse;
            }
            catch (Exception e) {
                String errorMessage;
                block13: {
                    HttpResponse httpResponse;
                    block14: {
                        span.setAttribute(AttributeKey.ERROR.getKey(), true);
                        span.setStatus(Status.CANCELLED);
                        errorMessage = "Unable to execute request for an existing session: " + e.getMessage();
                        Tags.EXCEPTION.accept(attributeMap, e);
                        attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), errorMessage);
                        span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                        if (!(e instanceof NoSuchSessionException)) break block13;
                        HttpResponse response = new HttpResponse();
                        response.setStatus(404);
                        response.setContent(Contents.asJson((Object)ErrorCodec.createDefault().encode((Throwable)e)));
                        httpResponse = response;
                        if (span == null) break block14;
                        span.close();
                    }
                    return httpResponse;
                }
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause != null) {
                    throw new RuntimeException(errorMessage, cause);
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(errorMessage, e);
            }
        }
    }

    private Callable<HttpHandler> loadSessionId(Tracer tracer, Span span, SessionId id) {
        return span.wrap(() -> {
            Session session = this.sessions.get(id);
            URL url = Urls.fromUri((URI)session.getUri());
            ClientConfig config = ClientConfig.defaultConfig().baseUrl(url).withRetries();
            HttpClient client = (HttpClient)this.httpClients.get((Object)url, () -> this.httpClientFactory.createClient(config));
            return new ReverseProxyHandler(tracer, client);
        });
    }
}

