/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.internal.Console;
import com.beust.jcommander.internal.DefaultConsole;
import com.google.auto.service.AutoService;
import java.io.PrintStream;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.grid.config.DescribedOption;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.grid.server.HelpFlags;

@AutoService(value={CliCommand.class})
public class CompletionCommand
implements CliCommand {
    @Override
    public String getName() {
        return "completion";
    }

    @Override
    public String getDescription() {
        return "Generate shell autocompletions";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return StandardGridRoles.ALL_ROLES;
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.singleton(new HelpFlags());
    }

    @Override
    public CliCommand.Executable configure(PrintStream out, PrintStream err, String ... args) {
        HelpFlags help = new HelpFlags();
        Zsh zsh = new Zsh();
        JCommander commander = JCommander.newBuilder().programName("selenium").addObject((Object)help).addCommand((Object)zsh).build();
        commander.setConsole((Console)new DefaultConsole(out));
        return () -> {
            try {
                commander.parse(args);
            }
            catch (ParameterException e) {
                err.println(e.getMessage());
                commander.usage();
                return;
            }
            if (help.displayHelp(commander, out)) {
                return;
            }
            if (args.length == 0) {
                commander.parse(new String[0]);
            }
            switch (commander.getParsedCommand()) {
                case "zsh": {
                    this.outputZshCompletions(out);
                    break;
                }
                default: {
                    err.println("Unrecognised shell: " + commander.getParsedCommand());
                    System.exit(1);
                }
            }
        };
    }

    private void outputZshCompletions(PrintStream out) {
        Map<CliCommand, Set<DescribedOption>> allCommands = this.listKnownCommands();
        out.println("#compdef selenium");
        out.println("local context state state_descr line");
        out.println("typeset -A opt_args");
        out.println("_selenium() {");
        out.println("  _arguments -C \\");
        out.println("    '(- :)--ext[Amend the classpath for Grid]: :->arg' \\");
        out.println("    '(-): :->command' \\");
        out.println("    '(-)*:: :->arg' && return");
        out.println("  case $state in");
        out.println("    (command)");
        out.println("      local cmds");
        out.println("      cmds=(");
        allCommands.keySet().stream().sorted(Comparator.comparing(CliCommand::getName)).forEach(cmd -> out.println(String.format("        '%s:%s'", cmd.getName(), cmd.getDescription().replace("'", "\\'"))));
        out.println("      )");
        out.println("      _describe 'commands' cmds");
        out.println("      ;;");
        out.println("    (arg)");
        out.println("      case ${words[1]} in");
        allCommands.keySet().stream().sorted(Comparator.comparing(CliCommand::getName)).forEach(cmd -> {
            String shellName = cmd.getName().replace('-', '_');
            out.println(String.format("        (%s)", cmd.getName()));
            out.println(String.format("          _selenium_%s", shellName));
            out.println("          ;;");
        });
        out.println("      esac");
        out.println("      ;;");
        out.println("  esac");
        out.println("}\n\n");
        allCommands.forEach((cmd, options) -> {
            out.println(String.format("_selenium_%s() {", cmd.getName().replace('-', '_')));
            out.println("  args=(");
            options.stream().filter(opt -> !opt.flags().isEmpty()).sorted(Comparator.comparing(opt -> (String)opt.flags().iterator().next())).forEach(opt -> {
                String quotedDesc = opt.description.replace("'", "\\''").replace(":", "\\:");
                if (opt.flags().size() == 1) {
                    out.println(String.format("    '%s[%s]%s'", opt.flags().iterator().next(), quotedDesc, this.getZshType((DescribedOption)opt)));
                } else {
                    out.print("    '");
                    out.print(opt.flags.stream().collect(Collectors.joining(" ", "(", ")")));
                    out.print("'");
                    out.print(opt.flags.stream().collect(Collectors.joining(",", "{", "}")));
                    out.print("'");
                    out.print(String.format("[%s]", quotedDesc));
                    out.print(this.getZshType((DescribedOption)opt));
                    out.print("'\n");
                }
            });
            out.println("  )");
            out.println("  _arguments $args && return");
            out.println("}\n\n");
        });
        out.println("_selenium");
    }

    private String getZshType(DescribedOption option) {
        switch (option.type) {
            case "boolean": {
                return ":(true false)";
            }
            case "int": {
                return ":int";
            }
            case "list of strings": 
            case "string": {
                return ": ";
            }
            case "uri": 
            case "url": {
                return ":urls: ";
            }
            case "path": {
                return ":filename:_files";
            }
        }
        throw new IllegalStateException("Unknown type: " + option.type);
    }

    private Map<CliCommand, Set<DescribedOption>> listKnownCommands() {
        return StreamSupport.stream(ServiceLoader.load(CliCommand.class).spliterator(), true).map(command -> new AbstractMap.SimpleEntry<CliCommand, Set>((CliCommand)command, DescribedOption.findAllMatchingOptions(command.getConfigurableRoles()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Parameters(commandNames={"zsh"}, commandDescription="Create autocompletions for zsh")
    private static class Zsh {
        private Zsh() {
        }
    }
}

