/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.openqa.selenium.grid.web.Values;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.JsonToWebElementConverter;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.codec.jwp.JsonHttpCommandCodec;
import org.openqa.selenium.remote.codec.jwp.JsonHttpResponseCodec;
import org.openqa.selenium.remote.codec.w3c.W3CHttpCommandCodec;
import org.openqa.selenium.remote.codec.w3c.W3CHttpResponseCodec;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.TraceContext;
import org.openqa.selenium.remote.tracing.Tracer;

public class ProtocolConverter
implements HttpHandler {
    private static final Json JSON = new Json();
    private static final ImmutableSet<String> IGNORED_REQ_HEADERS = ImmutableSet.builder().add((Object)"connection").add((Object)"content-length").add((Object)"content-type").add((Object)"keep-alive").add((Object)"proxy-authorization").add((Object)"proxy-authenticate").add((Object)"proxy-connection").add((Object)"te").add((Object)"trailer").add((Object)"transfer-encoding").add((Object)"upgrade").build();
    private final Tracer tracer;
    private final HttpClient client;
    private final CommandCodec<HttpRequest> downstream;
    private final CommandCodec<HttpRequest> upstream;
    private final ResponseCodec<HttpResponse> downstreamResponse;
    private final ResponseCodec<HttpResponse> upstreamResponse;
    private final JsonToWebElementConverter converter;
    private final Function<HttpResponse, HttpResponse> newSessionConverter;

    public ProtocolConverter(Tracer tracer, HttpClient client, Dialect downstream, Dialect upstream) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.client = (HttpClient)Require.nonNull((String)"HTTP client", (Object)client);
        this.downstream = this.getCommandCodec((Dialect)Require.nonNull((String)"Downstream dialect", (Object)downstream));
        this.downstreamResponse = this.getResponseCodec(downstream);
        this.upstream = this.getCommandCodec((Dialect)Require.nonNull((String)"Upstream dialect", (Object)upstream));
        this.upstreamResponse = this.getResponseCodec(upstream);
        this.converter = new JsonToWebElementConverter(null);
        this.newSessionConverter = downstream == Dialect.W3C ? this::createW3CNewSessionResponse : this::createJwpNewSessionResponse;
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        try (Span span = HttpTracing.newSpanAsChildOf((Tracer)this.tracer, (HttpRequest)req, (String)"protocol_converter");){
            HttpResponse toReturn;
            HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
            attributeMap.put(AttributeKey.HTTP_HANDLER_CLASS.getKey(), EventAttribute.setValue((String)this.getClass().getName()));
            Command command = this.downstream.decode((Object)req);
            Tags.KIND.accept(span, Span.Kind.SERVER);
            Tags.HTTP_REQUEST.accept(span, req);
            Tags.HTTP_REQUEST_EVENT.accept(attributeMap, req);
            SessionId sessionId = command.getSessionId();
            RemoteTags.SESSION_ID.accept(span, sessionId);
            RemoteTags.SESSION_ID_EVENT.accept(attributeMap, sessionId);
            String commandName = command.getName();
            span.setAttribute("command.name", commandName);
            attributeMap.put("command.name", EventAttribute.setValue((String)commandName));
            attributeMap.put("downstream.command.parameters", EventAttribute.setValue((String)command.getParameters().toString()));
            Map parameters = (Map)this.converter.apply((Object)command.getParameters());
            command = new Command(command.getSessionId(), command.getName(), parameters);
            attributeMap.put("upstream.command.parameters", EventAttribute.setValue((String)command.getParameters().toString()));
            HttpRequest request = (HttpRequest)this.upstream.encode(command);
            HttpTracing.inject((Tracer)this.tracer, (TraceContext)span, (HttpRequest)request);
            HttpResponse res = this.makeRequest(request);
            if (!res.isSuccessful()) {
                span.setAttribute("error", true);
                span.setStatus(Status.UNKNOWN);
            }
            Tags.HTTP_RESPONSE.accept(span, res);
            Tags.HTTP_RESPONSE_EVENT.accept(attributeMap, res);
            if ("newSession".equals(command.getName()) && res.getStatus() == 200) {
                toReturn = this.newSessionConverter.apply(res);
            } else {
                Response decoded = this.upstreamResponse.decode((Object)res);
                toReturn = (HttpResponse)this.downstreamResponse.encode(HttpResponse::new, decoded);
            }
            res.getHeaderNames().forEach(name -> {
                if (!IGNORED_REQ_HEADERS.contains(name)) {
                    res.getHeaders(name).forEach(value -> toReturn.addHeader(name, value));
                }
            });
            span.addEvent("Protocol conversion completed", attributeMap);
            HttpResponse httpResponse = toReturn;
            return httpResponse;
        }
    }

    @VisibleForTesting
    HttpResponse makeRequest(HttpRequest request) {
        return this.client.execute(request);
    }

    private CommandCodec<HttpRequest> getCommandCodec(Dialect dialect) {
        switch (dialect) {
            case OSS: {
                return new JsonHttpCommandCodec();
            }
            case W3C: {
                return new W3CHttpCommandCodec();
            }
        }
        throw new IllegalStateException("Unknown dialect: " + dialect);
    }

    private ResponseCodec<HttpResponse> getResponseCodec(Dialect dialect) {
        switch (dialect) {
            case OSS: {
                return new JsonHttpResponseCodec();
            }
            case W3C: {
                return new W3CHttpResponseCodec();
            }
        }
        throw new IllegalStateException("Unknown dialect: " + dialect);
    }

    private HttpResponse createW3CNewSessionResponse(HttpResponse response) {
        Map value = (Map)JSON.toType(Contents.string((HttpMessage)response), Json.MAP_TYPE);
        Require.state((String)"Session id", value.get("sessionId")).nonNull();
        Require.state((String)"Response payload", value.get("value")).instanceOf(Map.class);
        return this.createResponse((ImmutableMap<String, Object>)ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"sessionId", value.get("sessionId"), (Object)"capabilities", value.get("value"))));
    }

    private HttpResponse createJwpNewSessionResponse(HttpResponse response) {
        Map value = Objects.requireNonNull((Map)Values.get(response, Json.MAP_TYPE));
        Require.state((String)"Session id", value.get("sessionId")).nonNull();
        Require.state((String)"Response payload", value.get("capabilities")).instanceOf(Map.class);
        return this.createResponse((ImmutableMap<String, Object>)ImmutableMap.of((Object)"status", (Object)0, (Object)"sessionId", value.get("sessionId"), (Object)"value", value.get("capabilities")));
    }

    private HttpResponse createResponse(ImmutableMap<String, Object> toSend) {
        byte[] bytes = JSON.toJson(toSend).getBytes(StandardCharsets.UTF_8);
        return (HttpResponse)((HttpResponse)((HttpResponse)new HttpResponse().setHeader("Content-Type", MediaType.JSON_UTF_8.toString())).setHeader("Content-Length", String.valueOf(bytes.length))).setContent(Contents.bytes((byte[])bytes));
    }
}

