/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.local;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.PersistentCapabilities;
import org.openqa.selenium.RetrySessionRequestException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.concurrent.Regularly;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.NodeDrainComplete;
import org.openqa.selenium.grid.data.NodeDrainStarted;
import org.openqa.selenium.grid.data.NodeHeartBeatEvent;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.data.SessionClosedEvent;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.data.SlotId;
import org.openqa.selenium.grid.docker.DockerSession;
import org.openqa.selenium.grid.jmx.JMXHelper;
import org.openqa.selenium.grid.jmx.ManagedAttribute;
import org.openqa.selenium.grid.jmx.ManagedService;
import org.openqa.selenium.grid.node.ActiveSession;
import org.openqa.selenium.grid.node.CapabilityResponseEncoder;
import org.openqa.selenium.grid.node.HealthCheck;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.grid.node.config.NodeOptions;
import org.openqa.selenium.grid.node.local.SessionSlot;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.internal.Debug;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.internal.ShutdownHooks;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.io.Zip;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tracer;

@ManagedService(objectName="org.seleniumhq.grid:type=Node,name=LocalNode", description="Node running the webdriver sessions.")
public class LocalNode
extends Node {
    private static final Json JSON = new Json();
    private static final Logger LOG = Logger.getLogger(LocalNode.class.getName());
    private final EventBus bus;
    private final URI externalUri;
    private final URI gridUri;
    private final Duration heartbeatPeriod;
    private final HealthCheck healthCheck;
    private final int maxSessionCount;
    private final List<SessionSlot> factories;
    private final Cache<SessionId, SessionSlot> currentSessions;
    private final Cache<SessionId, TemporaryFilesystem> tempFileSystems;
    private final AtomicInteger pendingSessions = new AtomicInteger();

    private LocalNode(Tracer tracer, EventBus bus, URI uri, URI gridUri, HealthCheck healthCheck, int maxSessionCount, Ticker ticker, Duration sessionTimeout, Duration heartbeatPeriod, List<SessionSlot> factories, Secret registrationSecret) {
        super(tracer, new NodeId(UUID.randomUUID()), uri, registrationSecret);
        this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
        this.externalUri = (URI)Require.nonNull((String)"Remote node URI", (Object)uri);
        this.gridUri = (URI)Require.nonNull((String)"Grid URI", (Object)gridUri);
        this.maxSessionCount = Math.min(Require.positive((String)"Max session count", (Integer)maxSessionCount), factories.size());
        this.heartbeatPeriod = heartbeatPeriod;
        this.factories = ImmutableList.copyOf(factories);
        Require.nonNull((String)"Registration secret", (Object)registrationSecret);
        this.healthCheck = healthCheck == null ? () -> new HealthCheck.Result(this.isDraining() ? Availability.DRAINING : Availability.UP, String.format("%s is %s", uri, this.isDraining() ? "draining" : "up")) : healthCheck;
        this.currentSessions = CacheBuilder.newBuilder().expireAfterAccess(sessionTimeout).ticker(ticker).removalListener(notification -> {
            LOG.log(Debug.getDebugLogLevel(), "Stopping session %s", ((SessionId)notification.getKey()).toString());
            SessionSlot slot = (SessionSlot)notification.getValue();
            if (!slot.isAvailable()) {
                slot.stop();
            }
        }).build();
        this.tempFileSystems = CacheBuilder.newBuilder().expireAfterAccess(sessionTimeout).ticker(ticker).removalListener(notification -> {
            TemporaryFilesystem tempFS = (TemporaryFilesystem)notification.getValue();
            tempFS.deleteTemporaryFiles();
            tempFS.deleteBaseDir();
        }).build();
        Regularly sessionCleanup = new Regularly("Session Cleanup Node: " + this.externalUri);
        sessionCleanup.submit(() -> this.currentSessions.cleanUp(), Duration.ofSeconds(30L), Duration.ofSeconds(30L));
        Regularly tmpFileCleanup = new Regularly("TempFile Cleanup Node: " + this.externalUri);
        tmpFileCleanup.submit(() -> this.tempFileSystems.cleanUp(), Duration.ofSeconds(30L), Duration.ofSeconds(30L));
        Regularly regularHeartBeat = new Regularly("Heartbeat Node: " + this.externalUri);
        regularHeartBeat.submit(() -> bus.fire(new NodeHeartBeatEvent(this.getStatus())), heartbeatPeriod, heartbeatPeriod);
        bus.addListener(SessionClosedEvent.listener(id -> {
            int done;
            if (this.isDraining() && (done = this.pendingSessions.decrementAndGet()) <= 0) {
                LOG.info("Firing node drain complete message");
                bus.fire(new NodeDrainComplete(this.getId()));
            }
        }));
        ShutdownHooks.add((Thread)new Thread(this::stopAllSessions));
        new JMXHelper().register(this);
    }

    public static Builder builder(Tracer tracer, EventBus bus, URI uri, URI gridUri, Secret registrationSecret) {
        return new Builder(tracer, bus, uri, gridUri, registrationSecret);
    }

    @Override
    public boolean isReady() {
        return this.bus.isReady();
    }

    @ManagedAttribute(name="CurrentSessions")
    @VisibleForTesting
    public int getCurrentSessionCount() {
        return Math.toIntExact(this.currentSessions.size());
    }

    @ManagedAttribute(name="MaxSessions")
    public int getMaxSessionCount() {
        return this.maxSessionCount;
    }

    @ManagedAttribute(name="Status")
    public Availability getAvailability() {
        return this.isDraining() ? Availability.DRAINING : Availability.UP;
    }

    @ManagedAttribute(name="TotalSlots")
    public int getTotalSlots() {
        return this.factories.size();
    }

    @ManagedAttribute(name="UsedSlots")
    public long getUsedSlots() {
        return this.factories.stream().filter(sessionSlot -> !sessionSlot.isAvailable()).count();
    }

    @ManagedAttribute(name="Load")
    public float getLoad() {
        long inUse = this.factories.stream().filter(sessionSlot -> !sessionSlot.isAvailable()).count();
        return (float)inUse / (float)this.maxSessionCount * 100.0f;
    }

    @ManagedAttribute(name="RemoteNodeUri")
    public URI getExternalUri() {
        return this.getUri();
    }

    @ManagedAttribute(name="GridUri")
    public URI getGridUri() {
        return this.gridUri;
    }

    @ManagedAttribute(name="NodeId")
    public String getNodeId() {
        return this.getId().toString();
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return this.factories.parallelStream().anyMatch(factory -> factory.test(capabilities));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Either<WebDriverException, CreateSessionResponse> newSession(CreateSessionRequest sessionRequest) {
        Require.nonNull((String)"Session request", (Object)sessionRequest);
        try (Span span = this.tracer.getCurrentContext().createSpan("node.new_session");){
            HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
            attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), EventAttribute.setValue((String)this.getClass().getName()));
            attributeMap.put("session.request.capabilities", EventAttribute.setValue((String)sessionRequest.getDesiredCapabilities().toString()));
            attributeMap.put("session.request.downstreamdialect", EventAttribute.setValue((String)sessionRequest.getDownstreamDialects().toString()));
            int currentSessionCount = this.getCurrentSessionCount();
            span.setAttribute("current.session.count", (Number)currentSessionCount);
            attributeMap.put("current.session.count", EventAttribute.setValue((long)currentSessionCount));
            if (this.getCurrentSessionCount() >= this.maxSessionCount) {
                span.setAttribute("error", true);
                span.setStatus(Status.RESOURCE_EXHAUSTED);
                attributeMap.put("max.session.count", EventAttribute.setValue((long)this.maxSessionCount));
                span.addEvent("Max session count reached", attributeMap);
                Either either = Either.left((Object)new RetrySessionRequestException("Max session count reached."));
                return either;
            }
            if (this.isDraining()) {
                span.setStatus(Status.UNAVAILABLE.withDescription("The node is draining. Cannot accept new sessions."));
                Either either = Either.left((Object)new RetrySessionRequestException("The node is draining. Cannot accept new sessions."));
                return either;
            }
            SessionSlot slotToUse = null;
            Either either = this.factories;
            synchronized (either) {
                for (SessionSlot factory : this.factories) {
                    if (!factory.isAvailable() || !factory.test(sessionRequest.getDesiredCapabilities())) continue;
                    factory.reserve();
                    slotToUse = factory;
                    break;
                }
            }
            if (slotToUse == null) {
                span.setAttribute("error", true);
                span.setStatus(Status.NOT_FOUND);
                span.addEvent("No slot matched the requested capabilities. ", attributeMap);
                either = Either.left((Object)new RetrySessionRequestException("No slot matched the requested capabilities."));
                return either;
            }
            Either<WebDriverException, ActiveSession> possibleSession = slotToUse.apply(sessionRequest);
            if (possibleSession.isRight()) {
                ActiveSession session = (ActiveSession)possibleSession.right();
                this.currentSessions.put((Object)session.getId(), (Object)slotToUse);
                SessionId sessionId = session.getId();
                Capabilities caps = session.getCapabilities();
                RemoteTags.SESSION_ID.accept(span, sessionId);
                RemoteTags.CAPABILITIES.accept(span, caps);
                String downstream = session.getDownstreamDialect().toString();
                String upstream = session.getUpstreamDialect().toString();
                String sessionUri = session.getUri().toString();
                span.setAttribute(AttributeKey.DOWNSTREAM_DIALECT.getKey(), downstream);
                span.setAttribute(AttributeKey.UPSTREAM_DIALECT.getKey(), upstream);
                span.setAttribute(AttributeKey.SESSION_URI.getKey(), sessionUri);
                boolean isSupportingCdp = slotToUse.isSupportingCdp() || caps.getCapability("se:cdp") != null;
                Session externalSession = this.createExternalSession(session, this.externalUri, isSupportingCdp);
                Either either2 = Either.right((Object)new CreateSessionResponse(externalSession, (byte[])CapabilityResponseEncoder.getEncoder(session.getDownstreamDialect()).apply(externalSession)));
                return either2;
            }
            slotToUse.release();
            span.setAttribute("error", true);
            span.addEvent("Unable to create session with the driver", attributeMap);
            Either either3 = Either.left((Object)((WebDriverException)possibleSession.left()));
            return either3;
        }
    }

    @Override
    public boolean isSessionOwner(SessionId id) {
        Require.nonNull((String)"Session ID", (Object)id);
        return this.currentSessions.getIfPresent((Object)id) != null;
    }

    @Override
    public Session getSession(SessionId id) throws NoSuchSessionException {
        Require.nonNull((String)"Session ID", (Object)id);
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot == null) {
            throw new NoSuchSessionException("Cannot find session with id: " + id);
        }
        return this.createExternalSession(slot.getSession(), this.externalUri, slot.isSupportingCdp());
    }

    @Override
    public TemporaryFilesystem getTemporaryFilesystem(SessionId id) throws IOException {
        try {
            return (TemporaryFilesystem)this.tempFileSystems.get((Object)id, () -> TemporaryFilesystem.getTmpFsBasedOn((File)TemporaryFilesystem.getDefaultTmpFS().createTempDir("session", id.toString())));
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public HttpResponse executeWebDriverCommand(HttpRequest req) {
        SessionId id = HttpSessionId.getSessionId((String)req.getUri()).map(SessionId::new).orElseThrow(() -> new NoSuchSessionException("Cannot find session: " + req));
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot == null) {
            throw new NoSuchSessionException("Cannot find session with id: " + id);
        }
        HttpResponse toReturn = slot.execute(req);
        if (req.getMethod() == HttpMethod.DELETE && req.getUri().equals("/session/" + id)) {
            this.stop(id);
        }
        return toReturn;
    }

    @Override
    public HttpResponse uploadFile(HttpRequest req, SessionId id) {
        File tempDir;
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot != null && slot.getSession() instanceof DockerSession) {
            return this.executeWebDriverCommand(req);
        }
        Map incoming = (Map)JSON.toType(Contents.string((HttpMessage)req), Json.MAP_TYPE);
        try {
            TemporaryFilesystem tempfs = this.getTemporaryFilesystem(id);
            tempDir = tempfs.createTempDir("upload", "file");
            Zip.unzip((String)((String)incoming.get("file")), (File)tempDir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        File[] allFiles = tempDir.listFiles();
        if (allFiles == null) {
            throw new WebDriverException(String.format("Cannot access temporary directory for uploaded files %s", tempDir));
        }
        if (allFiles.length != 1) {
            throw new WebDriverException(String.format("Expected there to be only 1 file. There were: %s", allFiles.length));
        }
        ImmutableMap result = ImmutableMap.of((Object)"value", (Object)allFiles[0].getAbsolutePath());
        return (HttpResponse)new HttpResponse().setContent(Contents.asJson((Object)result));
    }

    @Override
    public void stop(SessionId id) throws NoSuchSessionException {
        Require.nonNull((String)"Session ID", (Object)id);
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot == null) {
            throw new NoSuchSessionException("Cannot find session with id: " + id);
        }
        this.currentSessions.invalidate((Object)id);
        this.tempFileSystems.invalidate((Object)id);
    }

    private void stopAllSessions() {
        if (this.currentSessions.size() > 0L) {
            LOG.info("Trying to stop all running sessions before shutting down...");
            this.currentSessions.invalidateAll();
        }
    }

    private Session createExternalSession(ActiveSession other, URI externalUri, boolean isSupportingCdp) {
        boolean isVncEnabled;
        ImmutableCapabilities toUse = ImmutableCapabilities.copyOf((Capabilities)other.getCapabilities());
        if (isSupportingCdp) {
            String cdpPath = String.format("/session/%s/se/cdp", other.getId());
            toUse = new PersistentCapabilities((Capabilities)toUse).setCapability("se:cdp", (Object)this.rewrite(cdpPath));
        }
        boolean bl = isVncEnabled = toUse.getCapability("se:vncLocalAddress") != null;
        if (isVncEnabled) {
            String vncPath = String.format("/session/%s/se/vnc", other.getId());
            toUse = new PersistentCapabilities((Capabilities)toUse).setCapability("se:vnc", (Object)this.rewrite(vncPath));
        }
        return new Session(other.getId(), externalUri, other.getStereotype(), (Capabilities)toUse, Instant.now());
    }

    private URI rewrite(String path) {
        try {
            String scheme = "https".equals(this.gridUri.getScheme()) ? "wss" : "ws";
            return new URI(scheme, this.gridUri.getUserInfo(), this.gridUri.getHost(), this.gridUri.getPort(), path, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NodeStatus getStatus() {
        Set slots = (Set)this.factories.stream().map(slot -> {
            ActiveSession activeSession;
            Instant lastStarted = Instant.EPOCH;
            Session session = null;
            if (!slot.isAvailable() && (activeSession = slot.getSession()) != null) {
                lastStarted = activeSession.getStartTime();
                session = new Session(activeSession.getId(), activeSession.getUri(), slot.getStereotype(), activeSession.getCapabilities(), activeSession.getStartTime());
            }
            return new Slot(new SlotId(this.getId(), slot.getId()), slot.getStereotype(), lastStarted, session);
        }).collect(ImmutableSet.toImmutableSet());
        return new NodeStatus(this.getId(), this.externalUri, this.maxSessionCount, slots, this.isDraining() ? Availability.DRAINING : Availability.UP, this.heartbeatPeriod, this.getNodeVersion(), (Map<String, String>)this.getOsInfo());
    }

    @Override
    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    @Override
    public void drain() {
        this.bus.fire(new NodeDrainStarted(this.getId()));
        this.draining = true;
        int currentSessionCount = this.getCurrentSessionCount();
        if (currentSessionCount == 0) {
            LOG.info("Firing node drain complete message");
            this.bus.fire(new NodeDrainComplete(this.getId()));
        } else {
            this.pendingSessions.set(currentSessionCount);
        }
    }

    private Map<String, Object> toJson() {
        return ImmutableMap.of((Object)"id", (Object)this.getId(), (Object)"uri", (Object)this.externalUri, (Object)"maxSessions", (Object)this.maxSessionCount, (Object)"draining", (Object)this.isDraining(), (Object)"capabilities", this.factories.stream().map(SessionSlot::getStereotype).collect(Collectors.toSet()));
    }

    public static class Builder {
        private final Tracer tracer;
        private final EventBus bus;
        private final URI uri;
        private final URI gridUri;
        private final Secret registrationSecret;
        private final ImmutableList.Builder<SessionSlot> factories;
        private int maxCount = NodeOptions.DEFAULT_MAX_SESSIONS;
        private Ticker ticker = Ticker.systemTicker();
        private Duration sessionTimeout = Duration.ofSeconds(300L);
        private HealthCheck healthCheck;
        private Duration heartbeatPeriod = Duration.ofSeconds(60L);

        private Builder(Tracer tracer, EventBus bus, URI uri, URI gridUri, Secret registrationSecret) {
            this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
            this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
            this.uri = (URI)Require.nonNull((String)"Remote node URI", (Object)uri);
            this.gridUri = (URI)Require.nonNull((String)"Grid URI", (Object)gridUri);
            this.registrationSecret = (Secret)Require.nonNull((String)"Registration secret", (Object)registrationSecret);
            this.factories = ImmutableList.builder();
        }

        public Builder add(Capabilities stereotype, SessionFactory factory) {
            Require.nonNull((String)"Capabilities", (Object)stereotype);
            Require.nonNull((String)"Session factory", (Object)factory);
            this.factories.add((Object)new SessionSlot(this.bus, stereotype, factory));
            return this;
        }

        public Builder maximumConcurrentSessions(int maxCount) {
            this.maxCount = Require.positive((String)"Max session count", (Integer)maxCount);
            return this;
        }

        public Builder sessionTimeout(Duration timeout) {
            this.sessionTimeout = timeout;
            return this;
        }

        public Builder heartbeatPeriod(Duration heartbeatPeriod) {
            this.heartbeatPeriod = heartbeatPeriod;
            return this;
        }

        public LocalNode build() {
            return new LocalNode(this.tracer, this.bus, this.uri, this.gridUri, this.healthCheck, this.maxCount, this.ticker, this.sessionTimeout, this.heartbeatPeriod, (List)this.factories.build(), this.registrationSecret);
        }

        public Advanced advanced() {
            return new Advanced();
        }

        public class Advanced {
            public Advanced clock(final Clock clock) {
                Builder.this.ticker = new Ticker(){

                    public long read() {
                        return clock.instant().toEpochMilli() * Duration.ofMillis(1L).toNanos();
                    }
                };
                return this;
            }

            public Advanced healthCheck(HealthCheck healthCheck) {
                Builder.this.healthCheck = (HealthCheck)Require.nonNull((String)"Health check", (Object)healthCheck);
                return this;
            }

            public Node build() {
                return Builder.this.build();
            }
        }
    }
}

