/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.PersistentCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.service.DriverService;

public class NodeOptions {
    public static final int DEFAULT_MAX_SESSIONS = Runtime.getRuntime().availableProcessors();
    public static final int DEFAULT_HEARTBEAT_PERIOD = 60;
    public static final int DEFAULT_SESSION_TIMEOUT = 300;
    static final String NODE_SECTION = "node";
    static final boolean DEFAULT_DETECT_DRIVERS = true;
    static final boolean OVERRIDE_MAX_SESSIONS = false;
    static final String DEFAULT_VNC_ENV_VAR = "START_XVFB";
    static final int DEFAULT_REGISTER_CYCLE = 10;
    static final int DEFAULT_REGISTER_PERIOD = 120;
    private static final Logger LOG = Logger.getLogger(NodeOptions.class.getName());
    private static final Json JSON = new Json();
    private static final String DEFAULT_IMPL = "org.openqa.selenium.grid.node.local.LocalNodeFactory";
    private static final Platform CURRENT_PLATFORM = Platform.getCurrent();
    private static final ImmutableSet<String> SINGLE_SESSION_DRIVERS = ImmutableSet.of((Object)"safari", (Object)"safari technology preview");
    private final Config config;
    private final AtomicBoolean vncEnabled = new AtomicBoolean();
    private final AtomicBoolean vncEnabledValueSet = new AtomicBoolean();

    public NodeOptions(Config config) {
        this.config = (Config)Require.nonNull((String)"Config", (Object)config);
    }

    public Optional<URI> getPublicGridUri() {
        return this.config.get(NODE_SECTION, "grid-url").map(url -> {
            try {
                return new URI((String)url);
            }
            catch (URISyntaxException e) {
                throw new ConfigException("Unable to construct public URL: " + url, new Object[0]);
            }
        });
    }

    public Node getNode() {
        return (Node)this.config.getClass(NODE_SECTION, "implementation", Node.class, DEFAULT_IMPL);
    }

    public Duration getRegisterCycle() {
        int seconds = Math.max(this.config.getInt(NODE_SECTION, "register-cycle").orElse(10), 1);
        return Duration.ofSeconds(seconds);
    }

    public Duration getRegisterPeriod() {
        int seconds = Math.max(this.config.getInt(NODE_SECTION, "register-period").orElse(120), 1);
        return Duration.ofSeconds(seconds);
    }

    public Duration getHeartbeatPeriod() {
        int seconds = Math.max(this.config.getInt(NODE_SECTION, "heartbeat-period").orElse(60), 1);
        return Duration.ofSeconds(seconds);
    }

    public Map<Capabilities, Collection<SessionFactory>> getSessionFactories(Function<Capabilities, Collection<SessionFactory>> factoryFactory) {
        int maxSessions;
        LOG.log(Level.INFO, "Detected {0} available processors", DEFAULT_MAX_SESSIONS);
        boolean overrideMaxSessions = this.config.getBool(NODE_SECTION, "override-max-sessions").orElse(false);
        if (overrideMaxSessions) {
            LOG.log(Level.WARNING, "Overriding max recommended number of {0} concurrent sessions. Session stability and reliability might suffer!", DEFAULT_MAX_SESSIONS);
            LOG.warning("One browser session is recommended per available processor. Safari is always limited to 1 session per host.");
            LOG.warning("Overriding this value for Internet Explorer is not recommended. Issues related to parallel testing with Internet Explored won't be accepted.");
            LOG.warning("Double check if enabling 'override-max-sessions' is really needed");
        }
        if ((maxSessions = this.getMaxSessions()) > DEFAULT_MAX_SESSIONS) {
            LOG.log(Level.WARNING, "Max sessions set to {0} ", maxSessions);
        }
        Map<WebDriverInfo, Collection<SessionFactory>> allDrivers = this.discoverDrivers(maxSessions, factoryFactory);
        ImmutableMultimap.Builder sessionFactories = ImmutableMultimap.builder();
        this.addDriverFactoriesFromConfig((ImmutableMultimap.Builder<Capabilities, SessionFactory>)sessionFactories);
        this.addDriverConfigs(factoryFactory, (ImmutableMultimap.Builder<Capabilities, SessionFactory>)sessionFactories);
        this.addSpecificDrivers(allDrivers, (ImmutableMultimap.Builder<Capabilities, SessionFactory>)sessionFactories);
        this.addDetectedDrivers(allDrivers, (ImmutableMultimap.Builder<Capabilities, SessionFactory>)sessionFactories);
        return sessionFactories.build().asMap();
    }

    public int getMaxSessions() {
        int maxSessions = this.config.getInt(NODE_SECTION, "max-sessions").orElse(DEFAULT_MAX_SESSIONS);
        Require.positive((String)"Driver max sessions", (Integer)maxSessions);
        boolean overrideMaxSessions = this.config.getBool(NODE_SECTION, "override-max-sessions").orElse(false);
        if (maxSessions > DEFAULT_MAX_SESSIONS && overrideMaxSessions) {
            return maxSessions;
        }
        return Math.min(maxSessions, DEFAULT_MAX_SESSIONS);
    }

    public Duration getSessionTimeout() {
        int seconds = Math.max(this.config.getInt(NODE_SECTION, "session-timeout").orElse(300), 10);
        return Duration.ofSeconds(seconds);
    }

    @VisibleForTesting
    boolean isVncEnabled() {
        String vncEnvVar = this.config.get(NODE_SECTION, "vnc-env-var").orElse(DEFAULT_VNC_ENV_VAR);
        if (!this.vncEnabledValueSet.getAndSet(true)) {
            this.vncEnabled.set(Boolean.parseBoolean(System.getenv(vncEnvVar)));
        }
        return this.vncEnabled.get();
    }

    private void addDriverFactoriesFromConfig(ImmutableMultimap.Builder<Capabilities, SessionFactory> sessionFactories) {
        this.config.getAll(NODE_SECTION, "driver-factories").ifPresent(allConfigs -> {
            if (allConfigs.size() % 2 != 0) {
                throw new ConfigException("Expected each driver class to be mapped to a config", new Object[0]);
            }
            Map<String, String> configMap = IntStream.range(0, allConfigs.size() / 2).boxed().collect(Collectors.toMap(i -> (String)allConfigs.get(2 * i), i -> (String)allConfigs.get(2 * i + 1)));
            configMap.forEach((clazz, config) -> {
                Capabilities stereotype = (Capabilities)JSON.toType(config, Capabilities.class);
                SessionFactory sessionFactory = this.createSessionFactory((String)clazz, stereotype);
                sessionFactories.put((Object)stereotype, (Object)sessionFactory);
            });
        });
    }

    private SessionFactory createSessionFactory(String clazz, Capabilities stereotype) {
        LOG.fine(String.format("Creating %s as instance of %s", clazz, SessionFactory.class));
        try {
            Class<?> ClassClazz = Class.forName(clazz, true, Thread.currentThread().getContextClassLoader());
            Method create = ClassClazz.getMethod("create", Config.class, Capabilities.class);
            if (!Modifier.isStatic(create.getModifiers())) {
                throw new IllegalArgumentException(String.format("Class %s's `create(Config, Capabilities)` method must be static", clazz));
            }
            if (!SessionFactory.class.isAssignableFrom(create.getReturnType())) {
                throw new IllegalArgumentException(String.format("Class %s's `create(Config, Capabilities)` method must be static", clazz));
            }
            return (SessionFactory)create.invoke(null, this.config, stereotype);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Class %s must have a static `create(Config, Capabilities)` method", clazz));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Unable to find class: " + clazz, e);
        }
    }

    private void addDriverConfigs(Function<Capabilities, Collection<SessionFactory>> factoryFactory, ImmutableMultimap.Builder<Capabilities, SessionFactory> sessionFactories) {
        HashMultimap driverConfigs = HashMultimap.create();
        this.config.getAll(NODE_SECTION, "driver-configuration").ifPresent(arg_0 -> this.lambda$addDriverConfigs$15((Multimap)driverConfigs, factoryFactory, arg_0));
        driverConfigs.asMap().entrySet().stream().peek(this::report).forEach(entry -> sessionFactories.putAll((Object)((WebDriverInfo)entry.getKey()).getCanonicalCapabilities(), (Iterable)entry.getValue()));
    }

    private void addDetectedDrivers(Map<WebDriverInfo, Collection<SessionFactory>> allDrivers, ImmutableMultimap.Builder<Capabilities, SessionFactory> sessionFactories) {
        if (!this.config.getBool(NODE_SECTION, "detect-drivers").orElse(true).booleanValue()) {
            return;
        }
        if (this.config.getAll(NODE_SECTION, "driver-implementation").isPresent()) {
            return;
        }
        allDrivers.entrySet().stream().peek(this::report).forEach(entry -> {
            Capabilities capabilities = this.enhanceStereotype(((WebDriverInfo)entry.getKey()).getCanonicalCapabilities());
            sessionFactories.putAll((Object)capabilities, (Iterable)entry.getValue());
        });
        if (sessionFactories.build().size() == 0) {
            String logMessage = "No drivers have been configured or have been found on PATH";
            LOG.warning(logMessage);
            throw new ConfigException(logMessage, new Object[0]);
        }
    }

    private void addSpecificDrivers(Map<WebDriverInfo, Collection<SessionFactory>> allDrivers, ImmutableMultimap.Builder<Capabilities, SessionFactory> sessionFactories) {
        if (!this.config.getAll(NODE_SECTION, "driver-implementation").isPresent()) {
            return;
        }
        if (!this.config.getBool(NODE_SECTION, "detect-drivers").orElse(true).booleanValue()) {
            String logMessage = "Specific drivers cannot be added if 'detect-drivers' is set to false";
            LOG.warning(logMessage);
            throw new ConfigException(logMessage, new Object[0]);
        }
        List drivers = ((List)this.config.getAll(NODE_SECTION, "driver-implementation").orElse(new ArrayList())).stream().distinct().map(String::toLowerCase).peek(driver -> {
            boolean noneMatch = allDrivers.entrySet().stream().noneMatch(entry -> ((WebDriverInfo)entry.getKey()).getDisplayName().equalsIgnoreCase((String)driver));
            if (noneMatch) {
                LOG.log(Level.WARNING, "Could not find {0} driver on PATH.", driver);
            }
        }).collect(Collectors.toList());
        allDrivers.entrySet().stream().filter(entry -> drivers.contains(((WebDriverInfo)entry.getKey()).getDisplayName().toLowerCase())).findFirst().orElseThrow(() -> new ConfigException("No drivers were found for %s", new Object[]{drivers.toString()}));
        allDrivers.entrySet().stream().filter(entry -> drivers.contains(((WebDriverInfo)entry.getKey()).getDisplayName().toLowerCase())).sorted(Comparator.comparing(entry -> ((WebDriverInfo)entry.getKey()).getDisplayName().toLowerCase())).peek(this::report).forEach(entry -> {
            Capabilities capabilities = this.enhanceStereotype(((WebDriverInfo)entry.getKey()).getCanonicalCapabilities());
            sessionFactories.putAll((Object)capabilities, (Iterable)entry.getValue());
        });
    }

    private Map<WebDriverInfo, Collection<SessionFactory>> discoverDrivers(int maxSessions, Function<Capabilities, Collection<SessionFactory>> factoryFactory) {
        if (!this.config.getBool(NODE_SECTION, "detect-drivers").orElse(true).booleanValue()) {
            return ImmutableMap.of();
        }
        List<WebDriverInfo> infos = StreamSupport.stream(ServiceLoader.load(WebDriverInfo.class).spliterator(), false).filter(WebDriverInfo::isAvailable).sorted(Comparator.comparing(info -> info.getDisplayName().toLowerCase())).collect(Collectors.toList());
        LOG.log(Level.INFO, "Discovered {0} driver(s)", infos.size());
        ArrayList builders = new ArrayList();
        ServiceLoader.load(DriverService.Builder.class).forEach(builders::add);
        HashMultimap toReturn = HashMultimap.create();
        infos.forEach(arg_0 -> this.lambda$discoverDrivers$28(builders, maxSessions, (Multimap)toReturn, factoryFactory, arg_0));
        return toReturn.asMap();
    }

    private WebDriverInfo createConfiguredDriverInfo(final WebDriverInfo detectedDriver, final Capabilities canonicalCapabilities, final String displayName) {
        return new WebDriverInfo(){

            public String getDisplayName() {
                return displayName;
            }

            public Capabilities getCanonicalCapabilities() {
                return canonicalCapabilities;
            }

            public boolean isSupporting(Capabilities capabilities) {
                return detectedDriver.isSupporting(capabilities);
            }

            public boolean isSupportingCdp() {
                return detectedDriver.isSupportingCdp();
            }

            public boolean isAvailable() {
                return detectedDriver.isAvailable();
            }

            public int getMaximumSimultaneousSessions() {
                return detectedDriver.getMaximumSimultaneousSessions();
            }

            public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
                return Optional.empty();
            }
        };
    }

    private int getDriverMaxSessions(WebDriverInfo info, int desiredMaxSessions) {
        if (info.getMaximumSimultaneousSessions() == 1 && SINGLE_SESSION_DRIVERS.contains((Object)info.getDisplayName().toLowerCase())) {
            return info.getMaximumSimultaneousSessions();
        }
        boolean overrideMaxSessions = this.config.getBool(NODE_SECTION, "override-max-sessions").orElse(false);
        if (desiredMaxSessions > info.getMaximumSimultaneousSessions() && overrideMaxSessions) {
            String logMessage = String.format("Overriding max recommended number of %s concurrent sessions for %s, setting it to %s", info.getMaximumSimultaneousSessions(), info.getDisplayName(), desiredMaxSessions);
            LOG.log(Level.FINE, logMessage);
            return desiredMaxSessions;
        }
        return Math.min(info.getMaximumSimultaneousSessions(), desiredMaxSessions);
    }

    private Capabilities enhanceStereotype(Capabilities capabilities) {
        if (capabilities.getPlatformName() == null) {
            capabilities = new PersistentCapabilities(capabilities).setCapability("platformName", (Object)CURRENT_PLATFORM);
        }
        if (this.isVncEnabled()) {
            capabilities = new PersistentCapabilities(capabilities).setCapability("se:vncEnabled", (Object)true);
        }
        return capabilities;
    }

    private void report(Map.Entry<WebDriverInfo, Collection<SessionFactory>> entry) {
        StringBuilder caps = new StringBuilder();
        try (JsonOutput out = JSON.newOutput((Appendable)caps);){
            out.setPrettyPrint(false);
            out.write((Object)entry.getKey().getCanonicalCapabilities());
        }
        LOG.info(String.format("Adding %s for %s %d times", entry.getKey().getDisplayName(), caps.toString().replaceAll("\\s+", " "), entry.getValue().size()));
    }

    private /* synthetic */ void lambda$discoverDrivers$28(List builders, int maxSessions, Multimap toReturn, Function factoryFactory, WebDriverInfo info) {
        Capabilities caps = this.enhanceStereotype(info.getCanonicalCapabilities());
        builders.stream().filter(builder -> builder.score(caps) > 0).forEach(builder -> {
            int maxDriverSessions = this.getDriverMaxSessions(info, maxSessions);
            for (int i = 0; i < maxDriverSessions; ++i) {
                toReturn.putAll((Object)info, (Iterable)factoryFactory.apply(caps));
            }
        });
    }

    private /* synthetic */ void lambda$addDriverConfigs$15(Multimap driverConfigs, Function factoryFactory, List drivers) {
        if (drivers.size() == 0) {
            throw new ConfigException("No driver configs were found!", new Object[0]);
        }
        drivers.stream().filter(driver -> !driver.contains("=")).peek(driver -> LOG.warning(driver + " does not have the required 'key=value' structure for the configuration")).findFirst().ifPresent(ignore -> {
            throw new ConfigException("One or more driver configs does not have the required 'key=value' structure", new Object[0]);
        });
        int[] configIndexes = IntStream.range(0, drivers.size()).filter(index -> ((String)drivers.get(index)).startsWith("display-name")).toArray();
        if (configIndexes.length == 0) {
            throw new ConfigException("No 'display-name' keyword was found in the provided configs!", new Object[0]);
        }
        ArrayList driversMap = new ArrayList();
        for (int i = 0; i < configIndexes.length; ++i) {
            int fromIndex = configIndexes[i];
            int toIndex = i + 1 >= configIndexes.length ? drivers.size() : configIndexes[i + 1];
            HashMap configMap2 = new HashMap();
            drivers.subList(fromIndex, toIndex).forEach(keyValue -> configMap2.put(keyValue.split("=")[0], keyValue.split("=")[1]));
            driversMap.add(configMap2);
        }
        ArrayList builders = new ArrayList();
        ServiceLoader.load(DriverService.Builder.class).forEach(builders::add);
        ArrayList infos = new ArrayList();
        ServiceLoader.load(WebDriverInfo.class).forEach(infos::add);
        driversMap.forEach(configMap -> {
            if (!configMap.containsKey("stereotype")) {
                throw new ConfigException("Driver config is missing stereotype value. " + configMap, new Object[0]);
            }
            Capabilities confStereotype = (Capabilities)JSON.toType((String)configMap.get("stereotype"), Capabilities.class);
            if (configMap.containsKey("webdriver-executable")) {
                String webDriverExecutablePath = configMap.getOrDefault("webdriver-executable", "");
                File webDriverExecutable = new File(webDriverExecutablePath);
                if (!webDriverExecutable.isFile()) {
                    LOG.warning("Driver executable does not seem to be a file! " + webDriverExecutablePath);
                }
                if (!webDriverExecutable.canExecute()) {
                    LOG.warning("Driver file exists but does not seem to be a executable! " + webDriverExecutablePath);
                }
                confStereotype = new PersistentCapabilities(confStereotype).setCapability("se:webDriverExecutable", (Object)webDriverExecutablePath);
            }
            Capabilities stereotype = this.enhanceStereotype(confStereotype);
            String configName = configMap.getOrDefault("display-name", "Custom Slot Config");
            WebDriverInfo info = infos.stream().filter(webDriverInfo -> webDriverInfo.isSupporting(stereotype)).findFirst().orElseThrow(() -> new ConfigException("Unable to find matching driver for %s", new Object[]{stereotype}));
            int driverMaxSessions = Integer.parseInt(configMap.getOrDefault("max-sessions", String.valueOf(info.getMaximumSimultaneousSessions())));
            Require.positive((String)"Driver max sessions", (Integer)driverMaxSessions);
            WebDriverInfo driverInfoConfig = this.createConfiguredDriverInfo(info, stereotype, configName);
            builders.stream().filter(builder -> builder.score(stereotype) > 0).forEach(builder -> {
                int maxDriverSessions = this.getDriverMaxSessions(info, driverMaxSessions);
                for (int i = 0; i < maxDriverSessions; ++i) {
                    driverConfigs.putAll((Object)driverInfoConfig, (Iterable)factoryFactory.apply(stereotype));
                }
            });
        });
    }
}

