/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap;

import com.google.common.collect.ImmutableMap;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

class GetFromSessionMap
implements HttpHandler {
    private final Tracer tracer;
    private final SessionMap sessions;
    private final SessionId id;

    GetFromSessionMap(Tracer tracer, SessionMap sessions, SessionId id) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.sessions = (SessionMap)Require.nonNull((String)"Session map", (Object)sessions);
        this.id = (SessionId)Require.nonNull((String)"Session id", (Object)id);
    }

    public HttpResponse execute(HttpRequest req) {
        try (Span span = HttpTracing.newSpanAsChildOf((Tracer)this.tracer, (HttpRequest)req, (String)"sessions.get_session");){
            Tags.HTTP_REQUEST.accept(span, req);
            Session session = this.sessions.get(this.id);
            RemoteTags.SESSION_ID.accept(span, session.getId());
            RemoteTags.CAPABILITIES.accept(span, session.getCapabilities());
            span.setAttribute("session.uri", session.getUri().toString());
            HttpResponse httpResponse = (HttpResponse)new HttpResponse().setContent(Contents.asJson((Object)ImmutableMap.of((Object)"value", (Object)session)));
            return httpResponse;
        }
    }
}

