/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.events.zeromq;

import java.lang.reflect.Type;
import java.util.function.Consumer;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.events.EventListener;
import org.openqa.selenium.events.EventName;
import org.openqa.selenium.events.zeromq.BoundZmqEventBus;
import org.openqa.selenium.events.zeromq.UnboundZmqEventBus;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.security.SecretOptions;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;
import org.zeromq.ZContext;

public class ZeroMqEventBus {
    private static final String EVENTS_SECTION = "events";

    private ZeroMqEventBus() {
    }

    public static EventBus create(ZContext context, String publish, String subscribe, boolean bind, Secret secret) {
        if (bind) {
            return new BoundZmqEventBus(context, publish, subscribe, secret);
        }
        return new UnboundZmqEventBus(context, publish, subscribe, secret);
    }

    public static EventBus create(Config config) {
        String publish = config.get(EVENTS_SECTION, "publish").orElseThrow(() -> new IllegalArgumentException("Unable to find address to publish events to."));
        String subscribe = config.get(EVENTS_SECTION, "subscribe").orElseThrow(() -> new IllegalArgumentException("Unable to find address to subscribe for events from."));
        boolean bind = config.getBool(EVENTS_SECTION, "bind").orElse(false);
        SecretOptions secretOptions = new SecretOptions(config);
        return ZeroMqEventBus.create(new ZContext(), publish, subscribe, bind, secretOptions.getRegistrationSecret());
    }

    public static EventListener<RejectedEvent> onRejectedEvent(Consumer<RejectedEvent> handler) {
        Require.nonNull((String)"Handler", handler);
        return new EventListener<RejectedEvent>(UnboundZmqEventBus.REJECTED_EVENT, (Type)((Object)RejectedEvent.class), handler);
    }

    public static class RejectedEvent {
        private final EventName name;
        private final Object data;

        RejectedEvent(EventName name, Object data) {
            this.name = name;
            this.data = data;
        }

        public EventName getName() {
            return this.name;
        }

        public Object getData() {
            return this.data;
        }

        private static RejectedEvent fromJson(JsonInput input) {
            EventName name = null;
            Object data = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "data": {
                        data = input.read(Object.class);
                        continue block8;
                    }
                    case "name": {
                        name = (EventName)input.read(EventName.class);
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new RejectedEvent(name, data);
        }
    }
}

