/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue.config;

import java.time.Duration;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.jmx.JMXHelper;
import org.openqa.selenium.grid.jmx.ManagedAttribute;
import org.openqa.selenium.grid.jmx.ManagedService;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;

@ManagedService(objectName="org.seleniumhq.grid:type=Config,name=NewSessionQueueConfig", description="New session queue config")
public class NewSessionQueueOptions {
    private static final String SESSIONS_QUEUE_SECTION = "sessionqueue";
    private static final String DEFAULT_NEWSESSION_QUEUE = "org.openqa.selenium.grid.sessionmap.remote.LocalNewSessionQueue";
    private static final int DEFAULT_REQUEST_TIMEOUT = 300;
    private static final int DEFAULT_RETRY_INTERVAL = 5;
    private final Config config;

    public NewSessionQueueOptions(Config config) {
        this.config = config;
        new JMXHelper().register(this);
    }

    public Duration getSessionRequestTimeout() {
        long timeout = this.config.getInt(SESSIONS_QUEUE_SECTION, "session-request-timeout").orElse(300).intValue();
        if (timeout <= 0L) {
            return Duration.ofSeconds(300L);
        }
        return Duration.ofSeconds(timeout);
    }

    public Duration getSessionRequestRetryInterval() {
        long interval = this.config.getInt(SESSIONS_QUEUE_SECTION, "session-retry-interval").orElse(5).intValue();
        if (interval <= 0L) {
            return Duration.ofSeconds(5L);
        }
        return Duration.ofSeconds(interval);
    }

    @ManagedAttribute(name="RequestTimeoutSeconds")
    public long getRequestTimeoutSeconds() {
        return this.getSessionRequestTimeout().getSeconds();
    }

    @ManagedAttribute(name="RetryIntervalSeconds")
    public long getRetryIntervalSeconds() {
        return this.getSessionRequestRetryInterval().getSeconds();
    }

    public NewSessionQueue getSessionQueue() {
        return this.config.getClass(SESSIONS_QUEUE_SECTION, "implementation", NewSessionQueue.class, DEFAULT_NEWSESSION_QUEUE);
    }
}

