/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.jmx.JMXHelper;
import org.openqa.selenium.grid.jmx.ManagedAttribute;
import org.openqa.selenium.grid.jmx.ManagedService;
import org.openqa.selenium.net.HostIdentifier;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.net.PortProber;

@ManagedService(objectName="org.seleniumhq.grid:type=Config,name=BaseServerConfig", description="Server config")
public class BaseServerOptions {
    private static final String SERVER_SECTION = "server";
    private static final Logger LOG = Logger.getLogger(BaseServerOptions.class.getName());
    private final Config config;
    private int port = -1;

    public BaseServerOptions(Config config) {
        this.config = config;
        new JMXHelper().register(this);
    }

    public Optional<String> getHostname() {
        return this.config.get(SERVER_SECTION, "hostname");
    }

    @ManagedAttribute(name="Port")
    public int getPort() {
        if (this.port == -1) {
            int newPort = this.config.getInt(SERVER_SECTION, "port").orElseGet(PortProber::findFreePort);
            if (newPort < 0) {
                throw new ConfigException("Port cannot be less than 0: " + newPort, new Object[0]);
            }
            this.port = newPort;
        }
        return this.port;
    }

    @ManagedAttribute(name="MaxServerThreads")
    public int getMaxServerThreads() {
        int count = this.config.getInt(SERVER_SECTION, "max-threads").orElse(200);
        if (count < 0) {
            throw new ConfigException("Maximum number of server threads cannot be less than 0: " + count, new Object[0]);
        }
        return count;
    }

    @ManagedAttribute(name="Uri")
    public URI getExternalUri() {
        String host = this.getHostname().orElseGet(() -> {
            try {
                return new NetworkUtils().getNonLoopbackAddressOfThisMachine();
            }
            catch (WebDriverException e) {
                String name = HostIdentifier.getHostName();
                LOG.info("No network connection, guessing name: " + name);
                return name;
            }
        });
        int port = this.getPort();
        try {
            return new URI(this.isSecure() || this.isSelfSigned() ? "https" : "http", null, host, port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new ConfigException("Cannot determine external URI: " + e.getMessage(), new Object[0]);
        }
    }

    public boolean getAllowCORS() {
        return this.config.getBool(SERVER_SECTION, "allow-cors").orElse(false);
    }

    public boolean isSecure() {
        return this.config.get(SERVER_SECTION, "https-private-key").isPresent() && this.config.get(SERVER_SECTION, "https-certificate").isPresent();
    }

    public File getPrivateKey() {
        String privateKey = this.config.get(SERVER_SECTION, "https-private-key").orElse(null);
        if (privateKey != null) {
            return new File(privateKey);
        }
        throw new ConfigException("Please provide a private key via --https-private-key when using --https", new Object[0]);
    }

    public File getCertificate() {
        String certificatePath = this.config.get(SERVER_SECTION, "https-certificate").orElse(null);
        if (certificatePath != null) {
            return new File(certificatePath);
        }
        throw new ConfigException("Please provide a certificate via --https-certificate when using --https", new Object[0]);
    }

    public boolean isSelfSigned() {
        return this.config.getBool(SERVER_SECTION, "https-self-signed").orElse(false);
    }
}

