/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.config;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.PersistentCapabilities;
import org.openqa.selenium.chromium.ChromiumDevToolsLocator;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.node.ActiveSession;
import org.openqa.selenium.grid.node.ProtocolConvertingSession;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.grid.node.config.BrowserOptionsMutator;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.service.DriverService;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

public class DriverServiceSessionFactory
implements SessionFactory {
    private final Tracer tracer;
    private final HttpClient.Factory clientFactory;
    private final Predicate<Capabilities> predicate;
    private final DriverService.Builder builder;
    private final Capabilities stereotype;
    private final BrowserOptionsMutator browserOptionsMutator;

    public DriverServiceSessionFactory(Tracer tracer, HttpClient.Factory clientFactory, Capabilities stereotype, Predicate<Capabilities> predicate, DriverService.Builder builder) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.clientFactory = (HttpClient.Factory)Require.nonNull((String)"HTTP client factory", (Object)clientFactory);
        this.stereotype = ImmutableCapabilities.copyOf((Capabilities)((Capabilities)Require.nonNull((String)"Stereotype", (Object)stereotype)));
        this.predicate = (Predicate)Require.nonNull((String)"Accepted capabilities predicate", predicate);
        this.builder = (DriverService.Builder)Require.nonNull((String)"Driver service builder", (Object)builder);
        this.browserOptionsMutator = new BrowserOptionsMutator(this.stereotype);
    }

    @Override
    public boolean test(Capabilities capabilities) {
        return this.predicate.test(capabilities);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<ActiveSession> apply(CreateSessionRequest sessionRequest) {
        if (sessionRequest.getDownstreamDialects().isEmpty()) {
            return Optional.empty();
        }
        if (!this.test(sessionRequest.getCapabilities())) {
            return Optional.empty();
        }
        try (Span span = this.tracer.getCurrentContext().createSpan("driver_service_factory.apply");){
            HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
            Capabilities capabilities = this.browserOptionsMutator.apply(sessionRequest.getCapabilities());
            RemoteTags.CAPABILITIES.accept(span, capabilities);
            RemoteTags.CAPABILITIES_EVENT.accept(attributeMap, capabilities);
            attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), EventAttribute.setValue((String)this.getClass().getName()));
            final DriverService service = this.builder.build();
            try {
                service.start();
                URL serviceURL = service.getUrl();
                attributeMap.put(AttributeKey.DRIVER_URL.getKey(), EventAttribute.setValue((String)serviceURL.toString()));
                final HttpClient client = this.clientFactory.createClient(serviceURL);
                Command command = new Command(null, DriverCommand.NEW_SESSION((Capabilities)capabilities));
                ProtocolHandshake.Result result = new ProtocolHandshake().createSession((HttpHandler)client, command);
                Set<Dialect> downstreamDialects = sessionRequest.getDownstreamDialects();
                Dialect upstream = result.getDialect();
                Dialect downstream = downstreamDialects.contains(result.getDialect()) ? result.getDialect() : downstreamDialects.iterator().next();
                Response response = result.createResponse();
                attributeMap.put(AttributeKey.UPSTREAM_DIALECT.getKey(), EventAttribute.setValue((String)upstream.toString()));
                attributeMap.put(AttributeKey.DOWNSTREAM_DIALECT.getKey(), EventAttribute.setValue((String)downstream.toString()));
                attributeMap.put(AttributeKey.DRIVER_RESPONSE.getKey(), EventAttribute.setValue((String)response.toString()));
                ImmutableCapabilities caps = new ImmutableCapabilities((Map)response.getValue());
                Optional reportedUri = ChromiumDevToolsLocator.getReportedUri((String)"goog:chromeOptions", (Capabilities)caps);
                if (reportedUri.isPresent()) {
                    caps = this.addCdpCapability((Capabilities)caps, (URI)reportedUri.get());
                } else {
                    reportedUri = ChromiumDevToolsLocator.getReportedUri((String)"ms:edgeOptions", (Capabilities)caps);
                    if (reportedUri.isPresent()) {
                        caps = this.addCdpCapability((Capabilities)caps, (URI)reportedUri.get());
                    }
                }
                span.addEvent("Driver service created session", attributeMap);
                Optional<ActiveSession> optional = Optional.of(new ProtocolConvertingSession(this.tracer, client, new SessionId(response.getSessionId()), service.getUrl(), downstream, upstream, this.stereotype, (Capabilities)caps, Instant.now()){

                    @Override
                    public void stop() {
                        service.stop();
                        try {
                            client.close();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                });
                return optional;
            }
            catch (Exception e) {
                Optional<ActiveSession> optional2;
                block16: {
                    span.setAttribute("error", true);
                    span.setStatus(Status.CANCELLED);
                    Tags.EXCEPTION.accept(attributeMap, e);
                    attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue((String)("Error while creating session with the driver service. Stopping driver service: " + e.getMessage())));
                    span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                    service.stop();
                    optional2 = Optional.empty();
                    if (span == null) break block16;
                    span.close();
                }
                return optional2;
            }
        }
        catch (Exception e2) {
            return Optional.empty();
        }
    }

    private Capabilities addCdpCapability(Capabilities caps, URI uri) {
        Object raw = caps.getCapability("se:options");
        if (!(raw instanceof Map)) {
            return new PersistentCapabilities(caps).setCapability("se:options", (Object)ImmutableMap.of((Object)"cdp", (Object)uri));
        }
        HashMap<String, URI> current = new HashMap<String, URI>((Map)raw);
        current.put("cdp", uri);
        return new PersistentCapabilities(caps).setCapability("se:options", (Object)ImmutableMap.copyOf(current));
    }
}

