/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor;

import java.io.UncheckedIOException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.SlotId;
import org.openqa.selenium.grid.distributor.AddNode;
import org.openqa.selenium.grid.distributor.DrainNode;
import org.openqa.selenium.grid.distributor.GetDistributorStatus;
import org.openqa.selenium.grid.distributor.RemoveNode;
import org.openqa.selenium.grid.distributor.selector.SlotSelector;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.security.RequiresSecretFilter;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.SpanDecorator;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.status.HasReadyState;

public abstract class Distributor
implements HasReadyState,
Predicate<HttpRequest>,
Routable {
    private static final Logger LOG = Logger.getLogger(Distributor.class.getName());
    private final Route routes;
    protected final Tracer tracer;
    private final SlotSelector slotSelector;
    private final SessionMap sessions;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);

    protected Distributor(Tracer tracer, HttpClient.Factory httpClientFactory, SlotSelector slotSelector, SessionMap sessions, Secret registrationSecret) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        Require.nonNull((String)"HTTP client factory", (Object)httpClientFactory);
        this.slotSelector = (SlotSelector)Require.nonNull((String)"Slot selector", (Object)slotSelector);
        this.sessions = (SessionMap)Require.nonNull((String)"Session map", (Object)sessions);
        Require.nonNull((String)"Registration secret", (Object)registrationSecret);
        RequiresSecretFilter requiresSecret = new RequiresSecretFilter(registrationSecret);
        Json json = new Json();
        this.routes = Route.combine((Routable)Route.post((String)"/se/grid/distributor/node").to(() -> new AddNode(tracer, this, json, httpClientFactory, registrationSecret)).with((Filter)requiresSecret), (Routable[])new Routable[]{Route.post((String)"/se/grid/distributor/node/{nodeId}/drain").to(params -> new DrainNode(this, new NodeId(UUID.fromString((String)params.get("nodeId"))))).with((Filter)requiresSecret), Route.delete((String)"/se/grid/distributor/node/{nodeId}").to(params -> new RemoveNode(this, new NodeId(UUID.fromString((String)params.get("nodeId"))))).with((Filter)requiresSecret), Route.get((String)"/se/grid/distributor/status").to(() -> new GetDistributorStatus(this)).with((Filter)new SpanDecorator(tracer, req -> "distributor.status"))});
    }

    /*
     * Exception decompiling
     */
    public Either<SessionNotCreatedException, CreateSessionResponse> newSession(HttpRequest request) throws SessionNotCreatedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public abstract Distributor add(Node var1);

    public abstract boolean drain(NodeId var1);

    public abstract void remove(NodeId var1);

    public abstract DistributorStatus getStatus();

    protected abstract Set<NodeStatus> getAvailableNodes();

    protected abstract Supplier<CreateSessionResponse> reserve(SlotId var1, CreateSessionRequest var2);

    @Override
    public boolean test(HttpRequest httpRequest) {
        return this.matches(httpRequest);
    }

    public boolean matches(HttpRequest req) {
        return this.routes.matches(req);
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        return this.routes.execute(req);
    }

    private static /* synthetic */ boolean lambda$newSession$5(CreateSessionRequest firstRequest, NodeStatus nodeStatus) {
        return nodeStatus.hasCapability(firstRequest.getCapabilities());
    }
}

