/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.internal.Require;

public class ContainerInfo {
    private final String ip;
    private final ContainerId id;
    private final List<Map<String, Object>> mountedVolumes;

    public ContainerInfo(ContainerId id, String ip, List<Map<String, Object>> mountedVolumes) {
        this.ip = (String)Require.nonNull((String)"Container ip address", (Object)ip);
        this.id = (ContainerId)Require.nonNull((String)"Container id", (Object)id);
        this.mountedVolumes = (List)Require.nonNull((String)"Mounted volumes", mountedVolumes);
    }

    public String getIp() {
        return this.ip;
    }

    public ContainerId getId() {
        return this.id;
    }

    public List<Map<String, Object>> getMountedVolumes() {
        return this.mountedVolumes;
    }

    public String toString() {
        return "ContainerInfo{ip=" + this.ip + ", id=" + this.id + '}';
    }

    public boolean equals(Object o) {
        if (!(o instanceof ContainerInfo)) {
            return false;
        }
        ContainerInfo that = (ContainerInfo)o;
        return Objects.equals(this.ip, that.ip) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.id);
    }
}

