/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.local;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.docker.DockerOptions;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.grid.node.config.DriverServiceSessionFactory;
import org.openqa.selenium.grid.node.config.NodeOptions;
import org.openqa.selenium.grid.node.local.LocalNode;
import org.openqa.selenium.grid.security.SecretOptions;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.service.DriverService;
import org.openqa.selenium.remote.tracing.Tracer;

public class LocalNodeFactory {
    public static Node create(Config config) {
        LoggingOptions loggingOptions = new LoggingOptions(config);
        EventBusOptions eventOptions = new EventBusOptions(config);
        BaseServerOptions serverOptions = new BaseServerOptions(config);
        NodeOptions nodeOptions = new NodeOptions(config);
        NetworkOptions networkOptions = new NetworkOptions(config);
        SecretOptions secretOptions = new SecretOptions(config);
        Tracer tracer = loggingOptions.getTracer();
        HttpClient.Factory clientFactory = networkOptions.getHttpClientFactory(tracer);
        LocalNode.Builder builder = LocalNode.builder(tracer, eventOptions.getEventBus(), serverOptions.getExternalUri(), nodeOptions.getPublicGridUri().orElseGet(serverOptions::getExternalUri), secretOptions.getRegistrationSecret());
        ArrayList builders = new ArrayList();
        ServiceLoader.load(DriverService.Builder.class).forEach(builders::add);
        nodeOptions.getSessionFactories(info -> LocalNodeFactory.createSessionFactory(tracer, clientFactory, builders, info)).forEach((caps, factories) -> factories.forEach(factory -> builder.add((Capabilities)caps, (SessionFactory)factory)));
        new DockerOptions(config).getDockerSessionFactories(tracer, clientFactory).forEach((caps, factories) -> factories.forEach(factory -> builder.add((Capabilities)caps, (SessionFactory)factory)));
        return builder.build();
    }

    private static Collection<SessionFactory> createSessionFactory(Tracer tracer, HttpClient.Factory clientFactory, List<DriverService.Builder<?, ?>> builders, WebDriverInfo info) {
        ImmutableList.Builder toReturn = ImmutableList.builder();
        Capabilities caps = info.getCanonicalCapabilities();
        builders.stream().filter(builder -> builder.score(caps) > 0).forEach(builder -> {
            DriverService.Builder freePortBuilder = builder.usingAnyFreePort();
            toReturn.add((Object)new DriverServiceSessionFactory(tracer, clientFactory, info.getCanonicalCapabilities(), c -> freePortBuilder.score(c) > 0, freePortBuilder));
        });
        return toReturn.build();
    }
}

