/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.log;

import io.opentelemetry.OpenTelemetry;
import io.opentelemetry.common.AttributeConsumer;
import io.opentelemetry.common.AttributeKey;
import io.opentelemetry.common.Attributes;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.MultiSpanProcessor;
import io.opentelemetry.sdk.trace.TracerSdkProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.log.FlushingHandler;
import org.openqa.selenium.grid.log.JaegerTracing;
import org.openqa.selenium.grid.log.JsonFormatter;
import org.openqa.selenium.grid.log.TerseFormatter;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.remote.tracing.empty.NullTracer;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryTracer;

public class LoggingOptions {
    private static final Logger LOG = Logger.getLogger(LoggingOptions.class.getName());
    private static final String LOGGING_SECTION = "logging";
    private static volatile Tracer tracer;
    public static final Json JSON;
    private final Config config;

    public LoggingOptions(Config config) {
        this.config = (Config)Require.nonNull((String)"Config", (Object)config);
    }

    public boolean isUsingStructuredLogging() {
        return this.config.getBool(LOGGING_SECTION, "structured-logs").orElse(false);
    }

    public boolean isUsingPlainLogs() {
        return this.config.getBool(LOGGING_SECTION, "plain-logs").orElse(true);
    }

    public String getLogEncoding() {
        return this.config.get(LOGGING_SECTION, "log-encoding").orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracer getTracer() {
        boolean tracingEnabled = this.config.getBool(LOGGING_SECTION, "tracing").orElse(true);
        if (!tracingEnabled) {
            LOG.info("Using null tracer");
            return new NullTracer();
        }
        LOG.info("Using OpenTelemetry for tracing");
        if (tracer != null) {
            return tracer;
        }
        Class<LoggingOptions> clazz = LoggingOptions.class;
        synchronized (LoggingOptions.class) {
            if (tracer == null) {
                tracer = this.createTracer();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return tracer;
        }
    }

    private Tracer createTracer() {
        LOG.info("Using OpenTelemetry for tracing");
        TracerSdkProvider tracerFactory = (TracerSdkProvider)OpenTelemetrySdk.getTracerManagement();
        LinkedList<SimpleSpanProcessor> exporters = new LinkedList<SimpleSpanProcessor>();
        exporters.add(SimpleSpanProcessor.newBuilder((SpanExporter)new SpanExporter(){

            public CompletableResultCode export(Collection<SpanData> spans) {
                spans.forEach(span -> {
                    LOG.fine(String.valueOf(span));
                    String traceId = span.getTraceId();
                    String spanId = span.getSpanId();
                    SpanData.Status status = span.getStatus();
                    List eventList = span.getEvents();
                    eventList.forEach(event -> {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("eventTime", event.getEpochNanos());
                        map.put("traceId", traceId);
                        map.put("spanId", spanId);
                        map.put("spanKind", span.getKind().toString());
                        map.put("eventName", event.getName());
                        Attributes attributes = event.getAttributes();
                        final HashMap attributeMap = new HashMap();
                        attributes.forEach(new AttributeConsumer(){

                            public <T> void consume(AttributeKey<T> key, T value) {
                                attributeMap.put(key.getKey(), value);
                            }
                        });
                        map.put("attributes", attributeMap);
                        String jsonString = LoggingOptions.this.getJsonString(map);
                        if (status.isOk()) {
                            LOG.log(Level.INFO, jsonString);
                        } else {
                            LOG.log(Level.WARNING, jsonString);
                        }
                    });
                });
                return CompletableResultCode.ofSuccess();
            }

            public CompletableResultCode flush() {
                return CompletableResultCode.ofSuccess();
            }

            public CompletableResultCode shutdown() {
                return CompletableResultCode.ofSuccess();
            }
        }).build());
        Optional<SpanExporter> maybeJaeger = JaegerTracing.findJaegerExporter();
        maybeJaeger.ifPresent(exporter -> exporters.add(SimpleSpanProcessor.newBuilder((SpanExporter)exporter).build()));
        tracerFactory.addSpanProcessor(MultiSpanProcessor.create(exporters));
        return new OpenTelemetryTracer(tracerFactory.get("default"), OpenTelemetry.getPropagators().getTextMapPropagator());
    }

    public void configureLogging() {
        String message;
        FlushingHandler handler;
        Logger logger;
        if (!this.config.getBool(LOGGING_SECTION, "enable").orElse(true).booleanValue()) {
            return;
        }
        LogManager logManager = LogManager.getLogManager();
        Enumeration<String> names = logManager.getLoggerNames();
        while (names.hasMoreElements()) {
            logger = logManager.getLogger(names.nextElement());
            Arrays.stream(logger.getHandlers()).forEach(logger::removeHandler);
        }
        logger = logManager.getLogger("");
        OutputStream out = this.getOutputStream();
        String encoding = this.getLogEncoding();
        if (this.isUsingPlainLogs()) {
            handler = new FlushingHandler(out);
            handler.setFormatter(new TerseFormatter());
            try {
                if (encoding != null) {
                    ((Handler)handler).setEncoding(encoding);
                    message = String.format("Using encoding %s", encoding);
                } else {
                    message = "Using the system default encoding";
                }
            }
            catch (UnsupportedEncodingException e) {
                message = String.format("Using the system default encoding. Unsupported encoding %s", encoding);
            }
            logger.addHandler(handler);
            logger.log(Level.INFO, message);
        }
        if (this.isUsingStructuredLogging()) {
            handler = new FlushingHandler(out);
            handler.setFormatter(new JsonFormatter());
            try {
                if (encoding != null) {
                    ((Handler)handler).setEncoding(encoding);
                    message = String.format("Using encoding %s", encoding);
                } else {
                    message = "Using the system default encoding";
                }
            }
            catch (UnsupportedEncodingException e) {
                message = String.format("Using the system default encoding. Unsupported encoding %s", encoding);
            }
            logger.addHandler(handler);
            logger.log(Level.INFO, message);
        }
    }

    private OutputStream getOutputStream() {
        return this.config.get(LOGGING_SECTION, "log-file").map(fileName -> {
            try {
                return new FileOutputStream((String)fileName);
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException(e);
            }
        }).orElse(System.out);
    }

    private String getJsonString(Map<String, Object> map) {
        StringBuilder text = new StringBuilder();
        try (JsonOutput json = JSON.newOutput((Appendable)text).setPrettyPrint(false);){
            json.write(map);
            text.append('\n');
        }
        return text.toString();
    }

    static {
        JSON = new Json();
    }
}

