/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.v1_40;

import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.docker.ContainerInfo;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class InspectContainer {
    private static final Logger LOG = Logger.getLogger(InspectContainer.class.getName());
    private static final Json JSON = new Json();
    private final HttpHandler client;

    public InspectContainer(HttpHandler client) {
        this.client = (HttpHandler)Require.nonNull((String)"HTTP client", (Object)client);
    }

    public ContainerInfo apply(ContainerId id) {
        Require.nonNull((String)"Container id", (Object)id);
        HttpResponse res = this.client.execute((HttpRequest)((HttpRequest)new HttpRequest(HttpMethod.GET, String.format("/v1.40/containers/%s/json", id)).addHeader("Content-Length", "0")).addHeader("Content-Type", "text/plain"));
        if (res.getStatus() != 200) {
            LOG.warning("Unable to inspect container " + id);
        }
        Map rawInspectInfo = (Map)JSON.toType(Contents.string((HttpMessage)res), Json.MAP_TYPE);
        Map networkSettings = (Map)rawInspectInfo.get("NetworkSettings");
        String ip = (String)networkSettings.get("IPAddress");
        return new ContainerInfo(id, ip);
    }
}

