/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router;

import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.router.GridStatusHandler;
import org.openqa.selenium.grid.router.HandleSession;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.SpanDecorator;
import org.openqa.selenium.remote.tracing.Tracer;

public class Router
implements Routable,
HttpHandler {
    private final Routable routes;

    public Router(Tracer tracer, HttpClient.Factory clientFactory, SessionMap sessions, Distributor distributor) {
        Require.nonNull((String)"Tracer to use", (Object)tracer);
        this.routes = Route.combine((Routable)Route.get((String)"/status").to(() -> new GridStatusHandler(new Json(), tracer, clientFactory, distributor)), (Routable[])new Routable[]{sessions.with((Filter)new SpanDecorator(tracer, req -> "session_map")), distributor.with((Filter)new SpanDecorator(tracer, req -> "distributor")), Route.matching(req -> req.getUri().startsWith("/session/")).to(() -> new HandleSession(tracer, clientFactory, sessions))});
    }

    public boolean matches(HttpRequest req) {
        return this.routes.matches(req);
    }

    public HttpResponse execute(HttpRequest req) {
        return this.routes.execute(req);
    }
}

