/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.httpd;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.TemplateGridCommand;
import org.openqa.selenium.grid.component.HealthCheck;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.grid.data.NodeAddedEvent;
import org.openqa.selenium.grid.data.NodeStatusEvent;
import org.openqa.selenium.grid.docker.DockerOptions;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.node.ProxyNodeCdp;
import org.openqa.selenium.grid.node.config.NodeOptions;
import org.openqa.selenium.grid.node.httpd.DefaultNodeConfig;
import org.openqa.selenium.grid.node.local.LocalNode;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.netty.server.NettyServer;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.tracing.Tracer;

public class NodeServer
extends TemplateGridCommand {
    private static final Logger LOG = Logger.getLogger(NodeServer.class.getName());

    @Override
    public String getName() {
        return "node";
    }

    @Override
    public String getDescription() {
        return "Adds this server as a node in the selenium grid.";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return ImmutableSet.of((Object)StandardGridRoles.EVENT_BUS_ROLE, (Object)StandardGridRoles.HTTPD_ROLE, (Object)StandardGridRoles.NODE_ROLE);
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.emptySet();
    }

    @Override
    protected String getSystemPropertiesConfigPrefix() {
        return "node";
    }

    @Override
    protected Config getDefaultConfig() {
        return new DefaultNodeConfig();
    }

    @Override
    protected void execute(Config config) {
        LoggingOptions loggingOptions = new LoggingOptions(config);
        Tracer tracer = loggingOptions.getTracer();
        EventBusOptions events = new EventBusOptions(config);
        EventBus bus = events.getEventBus();
        NetworkOptions networkOptions = new NetworkOptions(config);
        HttpClient.Factory clientFactory = networkOptions.getHttpClientFactory(tracer);
        BaseServerOptions serverOptions = new BaseServerOptions(config);
        LOG.info("Reporting self as: " + serverOptions.getExternalUri());
        NodeOptions nodeOptions = new NodeOptions(config);
        LocalNode.Builder builder = LocalNode.builder(tracer, bus, serverOptions.getExternalUri(), nodeOptions.getPublicGridUri().orElseGet(serverOptions::getExternalUri), serverOptions.getRegistrationSecret());
        nodeOptions.configure(tracer, clientFactory, builder);
        new DockerOptions(config).configure(tracer, clientFactory, builder);
        LocalNode node = builder.build();
        bus.addListener(NodeAddedEvent.NODE_ADDED, event -> {
            UUID nodeId = (UUID)event.getData((Type)((Object)UUID.class));
            if (node.getId().equals(nodeId)) {
                LOG.info("Node has been added");
            }
        });
        NettyServer server = new NettyServer(serverOptions, node, new ProxyNodeCdp(clientFactory, node));
        server.start();
        BuildInfo info = new BuildInfo();
        LOG.info(String.format("Started Selenium node %s (revision %s): %s", info.getReleaseLabel(), info.getBuildRevision(), server.getUrl()));
        RetryPolicy registrationPolicy = ((RetryPolicy)new RetryPolicy().withMaxAttempts(-1).handleResultIf(result -> true)).withBackoff(Duration.ofSeconds(5L).getSeconds(), Duration.ofMinutes(5L).getSeconds(), ChronoUnit.SECONDS, 1.0005);
        LOG.info("Starting registration process for node id " + node.getId());
        Executors.newSingleThreadExecutor().submit(() -> Failsafe.with((Policy[])new RetryPolicy[]{registrationPolicy}).run(() -> {
            LOG.fine("Sending registration event");
            HealthCheck.Result check = node.getHealthCheck().check();
            if (!check.isAlive()) {
                LOG.severe("Node is not alive: " + check.getMessage());
                throw new UnsupportedOperationException("Node cannot be registered");
            }
            bus.fire(new NodeStatusEvent(node.getStatus()));
        }));
    }
}

