/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.remote;

import java.net.URL;
import java.util.UUID;
import java.util.logging.Logger;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.web.Values;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.TraceContext;
import org.openqa.selenium.remote.tracing.Tracer;

public class RemoteDistributor
extends Distributor {
    private static final Logger LOG = Logger.getLogger("Selenium Distributor (Remote)");
    private final HttpHandler client;

    public RemoteDistributor(Tracer tracer, HttpClient.Factory factory, URL url) {
        super(tracer, factory);
        this.client = factory.createClient(url);
    }

    @Override
    public CreateSessionResponse newSession(HttpRequest request) throws SessionNotCreatedException {
        HttpRequest upstream = new HttpRequest(HttpMethod.POST, "/se/grid/distributor/session");
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)upstream);
        upstream.setContent(request.getContent());
        HttpResponse response = this.client.execute(upstream);
        return (CreateSessionResponse)Values.get(response, CreateSessionResponse.class);
    }

    @Override
    public RemoteDistributor add(Node node) {
        HttpRequest request = new HttpRequest(HttpMethod.POST, "/se/grid/distributor/node");
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)request);
        request.setContent(Contents.asJson((Object)node.getStatus()));
        HttpResponse response = this.client.execute(request);
        Values.get(response, Void.class);
        LOG.info(String.format("Added node %s.", node.getId()));
        return this;
    }

    @Override
    public void remove(UUID nodeId) {
        Require.nonNull((String)"Node ID", (Object)nodeId);
        HttpRequest request = new HttpRequest(HttpMethod.DELETE, "/se/grid/distributor/node/" + nodeId);
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)request);
        HttpResponse response = this.client.execute(request);
        Values.get(response, Void.class);
    }

    @Override
    public DistributorStatus getStatus() {
        HttpRequest request = new HttpRequest(HttpMethod.GET, "/se/grid/distributor/status");
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)request);
        HttpResponse response = this.client.execute(request);
        return (DistributorStatus)Values.get(response, DistributorStatus.class);
    }
}

